/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.mixin.renderers;

import dev.tazer.mixed_litter.MLConfig;
import dev.tazer.mixed_litter.VariantUtil;
import dev.tazer.mixed_litter.variants.remodels.CowVariant;
import net.minecraft.client.renderer.entity.CowRenderer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.level.LevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CowRenderer.class})
public class CowRendererMixin {
    @Inject(method={"getTextureLocation(Lnet/minecraft/world/entity/animal/Cow;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getVariantTextureLocation(Cow entity, CallbackInfoReturnable<ResourceLocation> cir) {
        if (((Boolean)MLConfig.COW.get()).booleanValue()) {
            CowVariant variant = null;
            for (Holder animalVariantHolder : VariantUtil.getVariants((Mob)entity, (LevelAccessor)entity.level())) {
                CowVariant cowVariant;
                Object object = animalVariantHolder.value();
                if (!(object instanceof CowVariant)) continue;
                variant = cowVariant = (CowVariant)object;
                break;
            }
            if (variant != null) {
                ResourceLocation texture = entity.isBaby() ? variant.babyTexture : variant.texture;
                cir.setReturnValue((Object)texture.withPath(path -> "textures/" + path + ".png"));
            }
        }
    }
}

