/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.mixin.renderers;

import dev.tazer.mixed_litter.VariantUtil;
import dev.tazer.mixed_litter.variants.monsters.DrownedVariant;
import net.minecraft.client.renderer.entity.DrownedRenderer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.LevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DrownedRenderer.class})
public class DrownedRendererMixin {
    @Inject(method={"getTextureLocation(Lnet/minecraft/world/entity/monster/Zombie;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getVariantTextureLocation(Zombie entity, CallbackInfoReturnable<ResourceLocation> cir) {
        DrownedVariant variant = null;
        for (Holder animalVariantHolder : VariantUtil.getVariants((Mob)entity, (LevelAccessor)entity.level())) {
            DrownedVariant drownedVariant;
            Object object = animalVariantHolder.value();
            if (!(object instanceof DrownedVariant)) continue;
            variant = drownedVariant = (DrownedVariant)object;
            break;
        }
        if (variant != null) {
            ResourceLocation texture = variant.texture;
            cir.setReturnValue((Object)texture.withPath(path -> "textures/" + path + ".png"));
        }
    }
}

