/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.mixin.renderers;

import dev.tazer.mixed_litter.VariantUtil;
import dev.tazer.mixed_litter.variants.animals.FoxVariant;
import net.minecraft.client.renderer.entity.FoxRenderer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.level.LevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FoxRenderer.class})
public class FoxRendererMixin {
    @Inject(method={"getTextureLocation(Lnet/minecraft/world/entity/animal/Fox;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getVariantTextureLocation(Fox entity, CallbackInfoReturnable<ResourceLocation> cir) {
        FoxVariant variant = null;
        for (Holder animalVariantHolder : VariantUtil.getVariants((Mob)entity, (LevelAccessor)entity.level())) {
            FoxVariant foxVariant;
            Object object = animalVariantHolder.value();
            if (!(object instanceof FoxVariant)) continue;
            variant = foxVariant = (FoxVariant)object;
            break;
        }
        if (variant != null) {
            ResourceLocation texture = entity.isSleeping() ? variant.sleepingTexture : variant.texture;
            cir.setReturnValue((Object)texture.withPath(path -> "textures/" + path + ".png"));
        }
    }
}

