/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.mixin.renderers;

import dev.tazer.mixed_litter.VariantUtil;
import dev.tazer.mixed_litter.variants.animals.LLamaVariant;
import net.minecraft.client.renderer.entity.LlamaRenderer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.level.LevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LlamaRenderer.class})
public class LLamaRendererMixin {
    @Inject(method={"getTextureLocation(Lnet/minecraft/world/entity/animal/horse/Llama;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="RETURN")}, cancellable=true)
    private void getVariantTextureLocation(Llama entity, CallbackInfoReturnable<ResourceLocation> cir) {
        LLamaVariant variant = null;
        for (Holder animalVariantHolder : VariantUtil.getVariants((Mob)entity, (LevelAccessor)entity.level())) {
            LLamaVariant lLamaVariant;
            Object object = animalVariantHolder.value();
            if (!(object instanceof LLamaVariant)) continue;
            variant = lLamaVariant = (LLamaVariant)object;
            break;
        }
        if (variant != null) {
            ResourceLocation texture = entity.isBaby() ? variant.babyTexture : variant.texture;
            cir.setReturnValue((Object)texture.withPath(path -> "textures/" + path + ".png"));
        }
    }
}

