/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.mixin.renderers;

import dev.tazer.mixed_litter.MLConfig;
import dev.tazer.mixed_litter.VariantUtil;
import dev.tazer.mixed_litter.variants.remodels.SheepVariant;
import net.minecraft.client.renderer.entity.SheepRenderer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.level.LevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SheepRenderer.class})
public class SheepRendererMixin {
    @Inject(method={"getTextureLocation(Lnet/minecraft/world/entity/animal/Sheep;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getVariantTextureLocation(Sheep entity, CallbackInfoReturnable<ResourceLocation> cir) {
        if (((Boolean)MLConfig.SHEEP.get()).booleanValue()) {
            SheepVariant variant = null;
            for (Holder animalVariantHolder : VariantUtil.getVariants((Mob)entity, (LevelAccessor)entity.level())) {
                SheepVariant sheepVariant;
                Object object = animalVariantHolder.value();
                if (!(object instanceof SheepVariant)) continue;
                variant = sheepVariant = (SheepVariant)object;
                break;
            }
            if (variant != null) {
                ResourceLocation texture = entity.isBaby() ? variant.babyTexture : variant.texture;
                cir.setReturnValue((Object)texture.withPath(path -> "textures/" + path + ".png"));
            }
        }
    }
}

