/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.mixin.renderers;

import dev.tazer.mixed_litter.MLConfig;
import dev.tazer.mixed_litter.VariantUtil;
import dev.tazer.mixed_litter.variants.remodels.SquidVariant;
import net.minecraft.client.renderer.entity.SquidRenderer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.level.LevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SquidRenderer.class})
public class SquidRendererMixin<T extends Squid> {
    @Inject(method={"getTextureLocation(Lnet/minecraft/world/entity/animal/Squid;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getVariantTextureLocation(T entity, CallbackInfoReturnable<ResourceLocation> cir) {
        if (((Boolean)MLConfig.SQUID.get()).booleanValue()) {
            SquidVariant variant = null;
            for (Holder animalVariantHolder : VariantUtil.getVariants(entity, (LevelAccessor)entity.level())) {
                SquidVariant squidVariant;
                Object object = animalVariantHolder.value();
                if (!(object instanceof SquidVariant)) continue;
                variant = squidVariant = (SquidVariant)object;
                break;
            }
            if (variant != null) {
                ResourceLocation texture = variant.texture;
                cir.setReturnValue((Object)texture.withPath(path -> "textures/" + path + ".png"));
            }
        }
    }
}

