/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.models;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.AgeableMob;

public class ChickenRemodel {
    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodyAdult = body.addOrReplaceChild("body_adult", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -2.5f, -3.5f, 5.0f, 5.0f, 7.0f), PartPose.offset((float)0.0f, (float)18.5f, (float)0.0f));
        partdefinition.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("red_thing", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(17, 0).addBox(-1.5f, -5.0f, -2.0f, 3.0f, 4.0f, 3.0f).texOffs(0, 0).addBox(-0.5f, -4.0f, -4.0f, 1.0f, 2.0f, 2.0f).texOffs(35, 7).addBox(0.0f, -7.0f, -3.0f, 0.0f, 7.0f, 3.0f), PartPose.offset((float)0.0f, (float)18.0f, (float)-2.5f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(38, 0).addBox(-0.5f, 0.0f, -2.0f, 2.0f, 3.0f, 2.0f), PartPose.offset((float)1.0f, (float)21.0f, (float)0.5f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(38, 0).mirror().addBox(-1.5f, 0.0f, -2.0f, 2.0f, 3.0f, 2.0f).mirror(false), PartPose.offset((float)-1.0f, (float)21.0f, (float)0.5f));
        partdefinition.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(30, 0).addBox(0.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f), PartPose.offset((float)2.5f, (float)16.0f, (float)-0.5f));
        partdefinition.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(30, 0).mirror().addBox(-1.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f).mirror(false), PartPose.offset((float)-2.5f, (float)16.0f, (float)-0.5f));
        bodyAdult.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(19, 8).addBox(-1.5f, -3.0f, -1.0f, 3.0f, 4.0f, 5.0f), PartPose.offset((float)0.0f, (float)-1.5f, (float)3.5f));
        PartDefinition bodyBaby = body.addOrReplaceChild("body_baby", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -1.5f, -1.0f, 4.0f, 3.0f, 4.0f), PartPose.offset((float)0.0f, (float)16.9f, (float)-0.5f));
        bodyBaby.addOrReplaceChild("head_baby", CubeListBuilder.create().texOffs(0, 7).addBox(-1.5f, -2.0f, -3.0f, 3.0f, 3.0f, 3.0f).texOffs(12, 0).addBox(-0.5f, -1.0f, -4.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.5f, (float)0.0f));
        bodyBaby.addOrReplaceChild("right_leg_baby", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 1.0f), PartPose.offset((float)-1.0f, (float)1.5f, (float)1.0f));
        bodyBaby.addOrReplaceChild("left_leg_baby", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 1.0f), PartPose.offset((float)1.0f, (float)1.5f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public static void setupAnim(AgeableMob chicken, ModelPart root, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelPart head = root.getChild("head");
        ModelPart body = root.getChild("body");
        ModelPart bodyAdult = body.getChild("body_adult");
        ModelPart rightWing = root.getChild("right_wing");
        ModelPart leftWing = root.getChild("left_wing");
        ModelPart rightLeg = root.getChild("right_leg");
        ModelPart leftLeg = root.getChild("left_leg");
        ModelPart bodyBaby = body.getChild("body_baby");
        ModelPart headBaby = bodyBaby.getChild("head_baby");
        ModelPart rightLegBaby = bodyBaby.getChild("right_leg_baby");
        ModelPart leftLegBaby = bodyBaby.getChild("left_leg_baby");
        boolean baby = chicken.isBaby();
        bodyBaby.xScale = 2.0f;
        bodyBaby.yScale = 2.0f;
        bodyBaby.zScale = 2.0f;
        head.xRot = headPitch * ((float)Math.PI / 180);
        head.yRot = netHeadYaw * ((float)Math.PI / 180);
        headBaby.xRot = head.xRot / 2.0f;
        headBaby.yRot = head.yRot / 2.0f;
        rightWing.zRot = ageInTicks;
        leftWing.zRot = -ageInTicks;
        bodyAdult.visible = !baby;
        head.visible = !baby;
        leftLeg.visible = !baby;
        rightLeg.visible = !baby;
        leftWing.visible = !baby;
        rightWing.visible = !baby;
        bodyBaby.visible = baby;
        rightLegBaby.xRot = rightLeg.xRot;
        leftLegBaby.xRot = leftLeg.xRot;
    }
}

