/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.models;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.AgeableMob;

public class CowRemodel {
    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodyAdult = body.addOrReplaceChild("body_adult", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -7.0f, -11.5f, 14.0f, 14.0f, 23.0f), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(67, 0).addBox(-4.0f, -6.0f, -6.0f, 8.0f, 11.0f, 8.0f).texOffs(74, 19).addBox(-4.0f, -6.0f, -6.0f, 8.0f, 11.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)3.0f, (float)-11.7f));
        head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(15, 16).mirror().addBox(0.0f, -1.0f, -0.5f, 3.0f, 2.0f, 1.0f).mirror(false), PartPose.offset((float)4.0f, (float)-3.0f, (float)-3.5f));
        head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(0, 16).addBox(-3.0f, -1.0f, -0.5f, 3.0f, 2.0f, 1.0f), PartPose.offset((float)-4.0f, (float)-3.0f, (float)-3.5f));
        head.addOrReplaceChild("left_horn", CubeListBuilder.create().texOffs(0, 19).mirror().addBox(0.0f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f).mirror(false).texOffs(8, 16).addBox(3.0f, -2.0f, -1.0f, 1.0f, 1.0f, 2.0f), PartPose.offset((float)4.0f, (float)-5.0f, (float)-3.0f));
        head.addOrReplaceChild("right_horn", CubeListBuilder.create().texOffs(0, 19).addBox(-4.0f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f).texOffs(8, 16).mirror().addBox(-4.0f, -2.0f, -1.0f, 1.0f, 1.0f, 2.0f).mirror(false), PartPose.offset((float)-4.0f, (float)-5.0f, (float)-3.0f));
        head.addOrReplaceChild("left_big_horn", CubeListBuilder.create().texOffs(51, 16).mirror().addBox(0.0f, -1.5f, -1.0f, 6.0f, 3.0f, 2.0f).mirror(false).texOffs(65, 19).mirror().addBox(4.0f, -3.5f, -1.0f, 2.0f, 2.0f, 2.0f).mirror(false), PartPose.offset((float)2.0f, (float)-5.5f, (float)-3.0f));
        head.addOrReplaceChild("right_big_horn", CubeListBuilder.create().texOffs(51, 16).addBox(-6.0f, -1.5f, -1.0f, 6.0f, 3.0f, 2.0f).texOffs(65, 19).addBox(-6.0f, -3.5f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)-2.0f, (float)-5.5f, (float)-3.0f));
        bodyAdult.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(3, 0).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 0.0f, 13.0f), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)11.5f, (float)-1.3963f, (float)0.0f, (float)0.0f));
        bodyAdult.addOrReplaceChild("udders", CubeListBuilder.create().texOffs(91, 0).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 2.0f, 6.0f), PartPose.offset((float)0.0f, (float)7.0f, (float)8.5f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-5.0f, (float)12.0f, (float)-9.5f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f).mirror(false), PartPose.offset((float)5.0f, (float)12.0f, (float)-9.5f));
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(51, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-5.0f, (float)12.0f, (float)9.5f));
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(51, 0).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f).mirror(false), PartPose.offset((float)5.0f, (float)12.0f, (float)9.5f));
        PartDefinition bodyBaby = body.addOrReplaceChild("body_baby", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -3.0f, -5.0f, 7.0f, 6.0f, 10.0f), PartPose.offset((float)0.0f, (float)5.75f, (float)0.0f));
        bodyBaby.addOrReplaceChild("right_front_leg_baby", CubeListBuilder.create().texOffs(20, 16).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f).mirror(false), PartPose.offset((float)-2.5f, (float)3.0f, (float)-4.0f));
        bodyBaby.addOrReplaceChild("left_front_leg_baby", CubeListBuilder.create().texOffs(20, 16).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offset((float)2.5f, (float)3.0f, (float)-4.0f));
        bodyBaby.addOrReplaceChild("right_hind_leg_baby", CubeListBuilder.create().texOffs(24, 0).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f).mirror(false), PartPose.offset((float)-2.5f, (float)3.0f, (float)4.0f));
        bodyBaby.addOrReplaceChild("left_hind_leg_baby", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offset((float)2.5f, (float)3.0f, (float)4.0f));
        PartDefinition headBaby = body.addOrReplaceChild("head_baby", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -3.0f, -3.0f, 5.0f, 6.0f, 5.0f).texOffs(34, 0).addBox(-2.5f, -3.0f, -3.0f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-11.0f));
        headBaby.addOrReplaceChild("right_ear_baby", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-2.0f, -1.0f, -0.5f, 2.0f, 2.0f, 1.0f).mirror(false), PartPose.offset((float)-2.5f, (float)-1.0f, (float)-1.5f));
        headBaby.addOrReplaceChild("left_ear_baby", CubeListBuilder.create().texOffs(0, 3).addBox(0.0f, -1.0f, -0.5f, 2.0f, 2.0f, 1.0f), PartPose.offset((float)2.5f, (float)-1.0f, (float)-1.5f));
        bodyBaby.addOrReplaceChild("tail_baby", CubeListBuilder.create().texOffs(20, 16).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 0.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)5.0f, (float)-1.2217f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public static void setupAnim(AgeableMob cow, ModelPart root) {
        ModelPart head = root.getChild("head");
        ModelPart body = root.getChild("body");
        ModelPart bodyAdult = body.getChild("body_adult");
        ModelPart rightHindLeg = root.getChild("right_hind_leg");
        ModelPart leftHindLeg = root.getChild("left_hind_leg");
        ModelPart rightFrontLeg = root.getChild("right_front_leg");
        ModelPart leftFrontLeg = root.getChild("left_front_leg");
        ModelPart headBaby = body.getChild("head_baby");
        ModelPart bodyBaby = body.getChild("body_baby");
        ModelPart rightFrontLegBaby = bodyBaby.getChild("right_front_leg_baby");
        ModelPart leftFrontLegBaby = bodyBaby.getChild("left_front_leg_baby");
        ModelPart rightHindLegBaby = bodyBaby.getChild("right_hind_leg_baby");
        ModelPart leftHindLegBaby = bodyBaby.getChild("left_hind_leg_baby");
        boolean baby = cow.isBaby();
        headBaby.xScale = 2.0f;
        headBaby.yScale = 2.0f;
        headBaby.zScale = 2.0f;
        bodyBaby.xScale = 2.0f;
        bodyBaby.yScale = 2.0f;
        bodyBaby.zScale = 2.0f;
        headBaby.xRot = head.xRot / 2.0f;
        headBaby.yRot = head.yRot / 2.0f;
        bodyAdult.visible = !baby;
        head.visible = !baby;
        leftHindLeg.visible = !baby;
        rightHindLeg.visible = !baby;
        leftFrontLeg.visible = !baby;
        rightFrontLeg.visible = !baby;
        bodyBaby.visible = baby;
        headBaby.visible = baby;
        rightHindLegBaby.xRot = rightHindLeg.xRot;
        leftHindLegBaby.xRot = leftHindLeg.xRot;
        rightFrontLegBaby.xRot = rightFrontLeg.xRot;
        leftFrontLegBaby.xRot = leftFrontLeg.xRot;
    }
}

