/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.models;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;

public class PigRemodel {
    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -5.0f, -8.0f, 10.0f, 10.0f, 16.0f).texOffs(0, 26).addBox(-5.0f, -5.0f, -9.0f, 10.0f, 5.0f, 1.0f).texOffs(22, 26).mirror().addBox(-3.0f, 2.0f, -11.0f, 2.0f, 2.0f, 3.0f).mirror(false).texOffs(32, 26).mirror().addBox(1.0f, 2.0f, -11.0f, 2.0f, 2.0f, 3.0f).mirror(false), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        head.addOrReplaceChild("snout", CubeListBuilder.create().texOffs(0, 6).addBox(-2.0f, -1.5f, -2.0f, 4.0f, 3.0f, 2.0f), PartPose.offset((float)0.0f, (float)1.5f, (float)-8.0f));
        head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(36, 0).mirror().addBox(-1.0f, 0.0f, -2.0f, 1.0f, 4.0f, 4.0f).mirror(false), PartPose.offsetAndRotation((float)-5.0f, (float)-4.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.2443f));
        head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(36, 0).addBox(0.0f, 0.0f, -2.0f, 1.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)5.0f, (float)-4.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-0.2443f));
        head.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 7).addBox(0.0f, -4.5f, 0.0f, 0.0f, 5.0f, 4.0f), PartPose.offset((float)0.0f, (float)-1.5f, (float)8.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(36, 8).addBox(-1.5f, -2.0f, -1.5f, 3.0f, 5.0f, 3.0f), PartPose.offset((float)-3.4f, (float)21.0f, (float)-4.5f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(36, 8).mirror().addBox(-1.5f, -2.0f, -1.5f, 3.0f, 5.0f, 3.0f).mirror(false), PartPose.offset((float)3.4f, (float)21.0f, (float)-4.5f));
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 3.0f, 3.0f).mirror(false), PartPose.offset((float)-3.4f, (float)21.0f, (float)6.5f));
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.5f, 0.0f, -1.5f, 3.0f, 3.0f, 3.0f).mirror(false), PartPose.offset((float)3.4f, (float)21.0f, (float)6.5f));
        PartDefinition headBaby = body.addOrReplaceChild("head_baby", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -2.5f, -4.0f, 5.0f, 5.0f, 8.0f), PartPose.offset((float)0.0f, (float)17.0f, (float)0.0f));
        headBaby.addOrReplaceChild("snout_baby", CubeListBuilder.create().texOffs(18, 0).addBox(-1.5f, -1.0f, -1.0f, 3.0f, 2.0f, 1.0f), PartPose.offset((float)0.0f, (float)1.5f, (float)-4.0f));
        headBaby.addOrReplaceChild("right_ear_baby", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.0f, 0.0f, -1.5f, 1.0f, 3.0f, 3.0f).mirror(false), PartPose.offset((float)-2.5f, (float)-2.5f, (float)-2.5f));
        headBaby.addOrReplaceChild("left_ear_baby", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, -1.5f, 1.0f, 3.0f, 3.0f), PartPose.offset((float)2.5f, (float)-2.5f, (float)-2.5f));
        headBaby.addOrReplaceChild("tail_baby", CubeListBuilder.create().texOffs(18, 0).addBox(0.0f, -2.5f, 0.0f, 0.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)4.0f));
        headBaby.addOrReplaceChild("right_front_leg_baby", CubeListBuilder.create().texOffs(0, 13).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f).mirror(false), PartPose.offset((float)-1.5f, (float)2.5f, (float)-2.0f));
        headBaby.addOrReplaceChild("left_front_leg_baby", CubeListBuilder.create().texOffs(0, 13).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.offset((float)1.5f, (float)2.5f, (float)-2.0f));
        headBaby.addOrReplaceChild("right_hind_leg_baby", CubeListBuilder.create().texOffs(8, 13).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f).mirror(false), PartPose.offset((float)-1.5f, (float)2.5f, (float)3.0f));
        headBaby.addOrReplaceChild("left_hind_leg_baby", CubeListBuilder.create().texOffs(8, 13).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.offset((float)1.5f, (float)2.5f, (float)3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static void setupAnim(AgeableMob pig, ModelPart root, float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch) {
        ModelPart head = root.getChild("head");
        ModelPart body = root.getChild("body");
        ModelPart rightHindLeg = root.getChild("right_hind_leg");
        ModelPart leftHindLeg = root.getChild("left_hind_leg");
        ModelPart rightFrontLeg = root.getChild("right_front_leg");
        ModelPart leftFrontLeg = root.getChild("left_front_leg");
        ModelPart headBaby = body.getChild("head_baby");
        ModelPart rightFrontLegBaby = headBaby.getChild("right_front_leg_baby");
        ModelPart leftFrontLegBaby = headBaby.getChild("left_front_leg_baby");
        ModelPart rightHindLegBaby = headBaby.getChild("right_hind_leg_baby");
        ModelPart leftHindLegBaby = headBaby.getChild("left_hind_leg_baby");
        ModelPart rightEar = head.getChild("right_ear");
        ModelPart leftEar = head.getChild("left_ear");
        boolean baby = pig.isBaby();
        headBaby.xScale = 2.0f;
        headBaby.yScale = 2.0f;
        headBaby.zScale = 2.0f;
        head.xRot = headPitch * ((float)Math.PI / 180) / 2.0f;
        head.yRot = netHeadYaw * ((float)Math.PI / 180) / 4.0f;
        headBaby.xRot = head.xRot / 2.0f;
        headBaby.yRot = head.yRot / 2.0f;
        rightHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.7f * limbSwingAmount;
        leftHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.7f * limbSwingAmount;
        rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.7f * limbSwingAmount;
        leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.7f * limbSwingAmount;
        head.visible = !baby;
        leftHindLeg.visible = !baby;
        rightHindLeg.visible = !baby;
        leftFrontLeg.visible = !baby;
        rightFrontLeg.visible = !baby;
        headBaby.visible = baby;
        if (!pig.onGround()) {
            rightEar.zRot = (float)Mth.lerp((double)0.5, (double)rightEar.zRot, (double)pig.getDeltaMovement().length());
        } else if (limbSwing > 0.0f) {
            rightEar.zRot = (float)Mth.lerp((double)0.5, (double)rightEar.zRot, (double)(Mth.abs((float)Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI))) * limbSwingAmount / 2.0f));
        }
        leftEar.zRot = -rightEar.zRot;
        rightHindLegBaby.xRot = rightHindLeg.xRot;
        leftHindLegBaby.xRot = leftHindLeg.xRot;
        rightFrontLegBaby.xRot = rightFrontLeg.xRot;
        leftFrontLegBaby.xRot = leftFrontLeg.xRot;
    }
}

