/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.networking;

import dev.tazer.mixed_litter.MLDataAttachmentTypes;
import dev.tazer.mixed_litter.VariantUtil;
import dev.tazer.mixed_litter.networking.VariantData;
import dev.tazer.mixed_litter.networking.VariantRequestData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class VariantPayloadHandler {
    public static void handleData(VariantData data, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity = context.player().level().getEntity(data.id());
            if (entity == null) {
                entity = EntityType.loadEntityRecursive((CompoundTag)data.tag(), (Level)context.player().level(), e -> e);
            }
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.setData(MLDataAttachmentTypes.MOB_VARIANTS, (Object)data.variants());
            }
        });
    }

    public static void handleRequestForData(VariantRequestData data, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity = context.player().level().getEntity(data.id());
            if (entity == null) {
                entity = EntityType.loadEntityRecursive((CompoundTag)data.tag(), (Level)context.player().level(), e -> e);
            }
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)mob, (CustomPacketPayload)VariantUtil.getVariantData(mob), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }
}

