/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.variants;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.tazer.mixed_litter.MixedLitter;
import dev.tazer.mixed_litter.requirement.NbtRequirement;
import dev.tazer.mixed_litter.variants.MobVariant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.fml.loading.FMLLoader;

public class DynamicVariant
extends MobVariant {
    public static final MapCodec<DynamicVariant> INNER_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(DynamicVariant::texture), (App)NbtRequirement.CODEC.optionalFieldOf("nbt", (Object)NbtRequirement.NONE).forGetter(DynamicVariant::nbt)).apply((Applicative)instance, (texture, nbt) -> new DynamicVariant(List.of(), 0, (ResourceLocation)texture, (NbtRequirement)nbt, List.of())));
    public static final MapCodec<DynamicVariant> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().listOf().fieldOf("entity_types").forGetter(DynamicVariant::entityTypes), (App)Codec.INT.optionalFieldOf("weight", (Object)1).forGetter(DynamicVariant::weight), (App)INNER_CODEC.codec().listOf().optionalFieldOf("sub_variants", List.of()).forGetter(DynamicVariant::subVariants)).apply((Applicative)instance, (entityTypes, weight, subVariants) -> new DynamicVariant((List<EntityType<?>>)entityTypes, (int)weight, null, NbtRequirement.NONE, (List<DynamicVariant>)subVariants)));
    private final int weight;
    private final ResourceLocation texture;
    private final NbtRequirement nbt;
    private final List<DynamicVariant> subVariants;
    private final List<EntityType<?>> entityTypes;

    public DynamicVariant(List<EntityType<?>> entityTypes, int weight, ResourceLocation texture, NbtRequirement nbt, List<DynamicVariant> subVariants) {
        super(entityTypes);
        this.entityTypes = entityTypes;
        this.weight = weight;
        this.texture = texture;
        this.nbt = nbt;
        this.subVariants = subVariants;
    }

    public DynamicVariant(EntityType<?> entityType, int weight, ResourceLocation texture, NbtRequirement nbt, List<DynamicVariant> subVariants) {
        this(List.of(entityType), weight, texture, nbt, subVariants);
    }

    public List<EntityType<?>> entityTypes() {
        return this.entityTypes;
    }

    @Override
    public int weight() {
        return this.weight;
    }

    public ResourceLocation texture() {
        return this.texture;
    }

    public NbtRequirement nbt() {
        return this.nbt;
    }

    public List<DynamicVariant> subVariants() {
        return this.subVariants;
    }

    @Override
    public DynamicVariant select(LivingEntity entity, LevelAccessor level, List<? extends MobVariant> animalVariants) {
        EntityType entityType = entity.getType();
        ArrayList variants = new ArrayList();
        animalVariants.forEach(animalVariant -> {
            if (animalVariant instanceof DynamicVariant) {
                DynamicVariant variant = (DynamicVariant)animalVariant;
                variants.add(variant);
            }
        });
        SimpleWeightedRandomList.Builder variantBuilder = SimpleWeightedRandomList.builder();
        for (DynamicVariant variant : variants) {
            if (!variant.entityTypes.stream().anyMatch(e -> e.equals(entityType))) continue;
            variantBuilder.add((Object)variant, variant.weight());
        }
        return variantBuilder.build().getRandomValue(entity.getRandom()).orElse(null);
    }

    public Optional<ResourceLocation> fetchTexture(LivingEntity entity) {
        List<DynamicVariant> subVariants = this.subVariants();
        for (DynamicVariant subVariant : subVariants) {
            if (!subVariant.nbt().test((Entity)entity)) continue;
            return Optional.of(subVariant.texture());
        }
        return Optional.empty();
    }

    @Override
    public MapCodec<? extends MobVariant> codec() {
        return INNER_CODEC;
    }

    public static <T> Codec<Either<TagKey<T>, T>> tagOrBuiltinCodec(ResourceKey<Registry<T>> vanillaRegistry, DefaultedRegistry<T> forgeRegistry) {
        return Codec.either((Codec)Codec.STRING.comapFlatMap(str -> {
            if (!str.startsWith("#")) {
                return DataResult.error(() -> String.format("Not a tag key for builtin registry %s: %s", vanillaRegistry.location(), str));
            }
            ResourceLocation itemLocation = ResourceLocation.parse((String)str.replace("#", ""));
            return DataResult.success((Object)TagKey.create((ResourceKey)vanillaRegistry, (ResourceLocation)itemLocation));
        }, key -> "#" + String.valueOf(key.location())), (Codec)Codec.STRING.comapFlatMap(str -> {
            ResourceLocation itemLocation = ResourceLocation.parse((String)str);
            Optional obj = forgeRegistry.getOptional(itemLocation);
            if (obj.isEmpty()) {
                if (FMLLoader.getLoadingModList().getModFileById(itemLocation.getNamespace()) != null) {
                    MixedLitter.LOGGER.error("Error deserializing config: object \"{}\" does not exist", str);
                    return DataResult.error(() -> "Object does not exist");
                }
                MixedLitter.LOGGER.warn("Could not parse {} because mod \"{}\" is not loaded", (Object)itemLocation, (Object)itemLocation.getNamespace());
                return DataResult.error(() -> "Required mod not loaded");
            }
            return DataResult.success(obj.get());
        }, obj -> {
            ResourceLocation itemLocation = forgeRegistry.getKey(obj);
            return itemLocation.toString();
        }));
    }
}

