/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.mixed_litter.variants.animals;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.tazer.mixed_litter.variants.MobVariant;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;

public class SalmonVariant
extends MobVariant {
    public static final MapCodec<SalmonVariant> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("weight").orElse((Object)1).forGetter(v -> v.weight), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).fieldOf("biomes").orElse((Object)HolderSet.empty()).forGetter(v -> v.biomes), (App)ResourceLocation.CODEC.fieldOf("texture").forGetter(v -> v.texture)).apply((Applicative)instance, SalmonVariant::new));
    public final int weight;
    public final HolderSet<Biome> biomes;
    public final ResourceLocation texture;

    public SalmonVariant(int weight, HolderSet<Biome> biomes, ResourceLocation texture) {
        super(List.of(EntityType.SALMON));
        this.weight = weight;
        this.biomes = biomes;
        this.texture = texture;
    }

    @Override
    public int weight() {
        return this.weight;
    }

    @Override
    public MobVariant select(LivingEntity entity, LevelAccessor level, List<? extends MobVariant> animalVariants) {
        MobVariant selectedVariant = animalVariants.getFirst();
        ArrayList variants = new ArrayList();
        animalVariants.forEach(animalVariant -> {
            if (animalVariant instanceof SalmonVariant) {
                SalmonVariant variant = (SalmonVariant)animalVariant;
                variants.add(variant);
            }
        });
        List<SalmonVariant> defaultVariants = variants.stream().filter(v -> v.biomes.size() == 0).toList();
        List<SalmonVariant> biomeVariants = variants.stream().filter(v -> v.biomes.size() > 0 && v.biomes.contains(level.getBiome(entity.blockPosition()))).toList();
        int cumulativeWeight = 0;
        if (!biomeVariants.isEmpty()) {
            int totalWeight = biomeVariants.stream().mapToInt(v -> v.weight).sum();
            int randomWeight = level.getRandom().nextInt(totalWeight);
            for (SalmonVariant variant : biomeVariants) {
                if (randomWeight >= (cumulativeWeight += variant.weight)) continue;
                selectedVariant = variant;
                break;
            }
        } else {
            int totalWeight = defaultVariants.stream().mapToInt(v -> v.weight).sum();
            int randomWeight = level.getRandom().nextInt(totalWeight);
            for (SalmonVariant variant : defaultVariants) {
                if (randomWeight >= (cumulativeWeight += variant.weight)) continue;
                selectedVariant = variant;
                break;
            }
        }
        return selectedVariant;
    }

    @Override
    public MapCodec<? extends MobVariant> codec() {
        return CODEC;
    }
}

