/*
 * Decompiled with CFR 0.152.
 */
package com.voxelpartum.minestuck_extended.client;

import com.mraof.minestuck.client.model.armor.ArmorModels;
import com.mraof.minestuck.item.armor.MSArmorItem;
import com.voxelpartum.minestuck_extended.client.model.armor.BeaglepissModel;
import com.voxelpartum.minestuck_extended.client.model.armor.BeaglepussModel;
import com.voxelpartum.minestuck_extended.client.model.armor.DisguiseModel;
import com.voxelpartum.minestuck_extended.client.model.armor.ScarletSunglasses;
import com.voxelpartum.minestuck_extended.client.model.armor.TestifipussModel;
import com.voxelpartum.minestuck_extended.item.MSEItems;
import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD, modid="minestuck_extended")
public class ClientProxy {
    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        ArmorModels.register((MSArmorItem)((MSArmorItem)MSEItems.BEAGLEPUSS.get()), (HumanoidModel)new HumanoidModel(BeaglepussModel.createBodyLayer().bakeRoot()));
        ArmorModels.register((MSArmorItem)((MSArmorItem)MSEItems.DISGUISE.get()), (HumanoidModel)new HumanoidModel(DisguiseModel.createBodyLayer().bakeRoot()));
        ArmorModels.register((MSArmorItem)((MSArmorItem)MSEItems.BEAGLEPISS.get()), (HumanoidModel)new HumanoidModel(BeaglepissModel.createBodyLayer().bakeRoot()));
        ArmorModels.register((MSArmorItem)((MSArmorItem)MSEItems.TESTIFIPUSS.get()), (HumanoidModel)new HumanoidModel(TestifipussModel.createBodyLayer().bakeRoot()));
        ArmorModels.register((MSArmorItem)((MSArmorItem)MSEItems.SCARLET_SUNGLASSES.get()), (HumanoidModel)new HumanoidModel(ScarletSunglasses.createBodyLayer().bakeRoot()));
    }

    @SubscribeEvent
    private static void registerExtensions(RegisterClientExtensionsEvent event) {
        for (final DeferredItem armorItem : Arrays.asList(MSEItems.BEAGLEPUSS, MSEItems.DISGUISE, MSEItems.BEAGLEPISS, MSEItems.TESTIFIPUSS, MSEItems.SCARLET_SUNGLASSES)) {
            event.registerItem(new IClientItemExtensions(){

                @NotNull
                public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                    ArmorItem.Type type = ((MSArmorItem)armorItem.get()).getType();
                    if (equipmentSlot != type.getSlot()) {
                        return original;
                    }
                    HumanoidModel model = ArmorModels.get((Item)((Item)armorItem.get()));
                    if (model == null) {
                        return original;
                    }
                    model.rightLeg.visible = type == ArmorItem.Type.LEGGINGS || type == ArmorItem.Type.BOOTS;
                    model.leftLeg.visible = type == ArmorItem.Type.LEGGINGS || type == ArmorItem.Type.BOOTS;
                    model.body.visible = type == ArmorItem.Type.CHESTPLATE;
                    model.leftArm.visible = type == ArmorItem.Type.CHESTPLATE;
                    model.rightArm.visible = type == ArmorItem.Type.CHESTPLATE;
                    model.head.visible = type == ArmorItem.Type.HELMET;
                    model.hat.visible = type == ArmorItem.Type.HELMET;
                    model.crouching = original.crouching;
                    model.riding = original.riding;
                    model.young = original.young;
                    model.rightArmPose = original.rightArmPose;
                    model.leftArmPose = original.leftArmPose;
                    return model;
                }
            }, new Holder[]{armorItem});
        }
    }
}

