/*
 * Decompiled with CFR 0.152.
 */
package com.voxelpartum.minestuck_extended.client.gui.captchalouge;

import com.mraof.minestuck.client.gui.captchalouge.SylladexScreen;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ArraySylladexScreen
extends SylladexScreen {
    private Modus modus;

    public ArraySylladexScreen(Modus modus) {
        this.modus = modus;
        this.textureIndex = 3;
    }

    public void updateContent() {
        NonNullList stacks = this.modus.getItems();
        this.cards.clear();
        int columns = (stacks.size() + 1) / 2;
        this.maxWidth = Math.max(this.mapWidth, 10 + (columns * 21 + (columns - 1) * 5));
        this.maxHeight = this.mapHeight;
        super.updateContent();
        int start = Math.max(5, (this.mapWidth - (columns * 21 + (columns - 1) * 5)) / 2);
        for (int i = 0; i < stacks.size(); ++i) {
            this.cards.add(new SylladexScreen.GuiCard((ItemStack)stacks.get(i), (SylladexScreen)this, i, start + i / 2 * 26, (this.mapHeight - 52 - 5) / 2 + i % 2 * 31));
        }
    }

    public void updatePosition() {
        int columns = (this.cards.size() + 1) / 2;
        this.maxWidth = Math.max(this.mapWidth, 10 + (columns * 21 + (columns - 1) * 5));
        this.maxHeight = this.mapHeight;
        int start = Math.max(5, (this.mapWidth - (columns * 21 + (columns - 1) * 5)) / 2);
        for (int i = 0; i < this.cards.size(); ++i) {
            SylladexScreen.GuiCard card = (SylladexScreen.GuiCard)this.cards.get(i);
            card.xPos = start + i / 2 * 26;
            card.yPos = (this.mapHeight - 52 - 5) / 2 + i % 2 * 31;
        }
    }

    public ResourceLocation getCardTexture(SylladexScreen.GuiCard card) {
        return ResourceLocation.fromNamespaceAndPath((String)"minestuck_extended", (String)"textures/gui/icons.png");
    }

    public int getCardTextureX(SylladexScreen.GuiCard card) {
        return 21 * this.textureIndex;
    }

    public int getCardTextureY(SylladexScreen.GuiCard card) {
        return 0;
    }
}

