/*
 * Decompiled with CFR 0.152.
 */
package com.voxelpartum.minestuck_extended.client.gui.captchalouge;

import com.mraof.minestuck.client.gui.captchalouge.SylladexScreen;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import com.voxelpartum.minestuck_extended.MinestuckExtendedConfig;
import java.util.Random;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class RouletteSylladexScreen
extends SylladexScreen {
    public Modus modus;

    public RouletteSylladexScreen(Modus modus) {
        this.modus = modus;
        this.textureIndex = 0;
    }

    public ResourceLocation getCardTexture(SylladexScreen.GuiCard card) {
        return ResourceLocation.fromNamespaceAndPath((String)"minestuck_extended", (String)"textures/gui/icons.png");
    }

    public int getCardTextureX(SylladexScreen.GuiCard card) {
        return 21 * (this.canUse((RouletteCard)card) ? this.textureIndex : this.textureIndex + 1);
    }

    public int getCardTextureY(SylladexScreen.GuiCard card) {
        return 0;
    }

    public void updateContent() {
        NonNullList stacks = this.modus.getItems();
        int randIndex = this.modus.getNonEmptyCards() == 0 ? 0 : new Random().nextInt((Boolean)MinestuckExtendedConfig.SERVER.useFullRoulette.get() != false ? this.modus.getSize() : this.modus.getNonEmptyCards());
        int radius = 50 + stacks.size() * stacks.size() / 16;
        this.cards.clear();
        this.maxWidth = Math.max(this.mapWidth, 2 * (radius + 16));
        this.maxHeight = Math.max(this.mapHeight, 2 * (radius + 17));
        super.updateContent();
        for (int i = 0; i < stacks.size(); ++i) {
            this.cards.add(new RouletteCard((ItemStack)stacks.get(i), this, i, (this.maxWidth - 16) / 2 + (int)((double)radius * Math.sin(Math.PI * 2 * (double)i / (double)stacks.size())), (this.maxHeight - 17) / 2 + (int)((double)radius * Math.cos(Math.PI * 2 * (double)i / (double)stacks.size())), i == randIndex));
        }
        this.updatePosition();
    }

    public void updatePosition() {
        int randIndex = this.modus.getNonEmptyCards() == 0 ? 0 : new Random().nextInt((Boolean)MinestuckExtendedConfig.SERVER.useFullRoulette.get() != false ? this.modus.getSize() : this.modus.getNonEmptyCards());
        int radius = (int)(50.0 + (double)(this.cards.size() * this.cards.size()) / 16.0);
        this.maxWidth = Math.max(this.mapWidth, 2 * (radius + 16));
        this.maxHeight = Math.max(this.mapHeight, 2 * (radius + 17));
        for (int i = 0; i < this.cards.size(); ++i) {
            RouletteCard card = (RouletteCard)((Object)this.cards.get(i));
            card.xPos = (this.maxWidth - 16) / 2 + (int)((double)radius * Math.sin(Math.PI * 2 * (double)i / (double)this.cards.size()));
            card.yPos = (this.maxHeight - 17) / 2 + (int)((double)radius * Math.cos(Math.PI * 2 * (double)i / (double)this.cards.size()));
            card.isUsable = card.index == randIndex;
        }
    }

    public boolean canUse(RouletteCard card) {
        return card.isUsable;
    }

    public static class RouletteCard
    extends SylladexScreen.GuiCard {
        RouletteSylladexScreen gui;
        public boolean isUsable;

        public RouletteCard(ItemStack item, RouletteSylladexScreen gui, int index, int xPos, int yPos, boolean isUsable) {
            super(item, (SylladexScreen)gui, index, xPos, yPos);
            this.gui = gui;
            this.isUsable = isUsable;
        }

        public void onClick(int mouseButton) {
            if (this.gui.canUse(this)) {
                super.onClick(mouseButton);
            }
            this.gui.updateContent();
        }
    }
}

