/*
 * Decompiled with CFR 0.152.
 */
package com.voxelpartum.minestuck_extended.compat;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import javax.annotation.Nonnull;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class RenchItem
extends Item {
    public RenchItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        return InteractionResultHolder.pass((Object)player.getItemInHand(usedHand));
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null || !player.mayBuild()) {
            return super.useOn(context);
        }
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        Block block = state.getBlock();
        if (!(block instanceof IWrenchable)) {
            if (player.isShiftKeyDown() && this.canWrenchPickup(state)) {
                RenchItem.dropItem(player);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        IWrenchable actor = (IWrenchable)block;
        if (player.isShiftKeyDown()) {
            RenchItem.dropItem(player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean canWrenchPickup(BlockState state) {
        return AllTags.AllBlockTags.WRENCH_PICKUP.matches(state);
    }

    private static void dropItem(Player player) {
        ItemStack dropItem = player.getItemBySlot(EquipmentSlot.MAINHAND);
        ItemEntity item = new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), dropItem.copy());
        item.getItem().setCount(1);
        item.setPickUpDelay(40);
        player.level().addFreshEntity((Entity)item);
        player.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.AIR));
    }
}

