/*
 * Decompiled with CFR 0.152.
 */
package com.voxelpartum.minestuck_extended.data;

import com.mraof.minestuck.data.MSBlockStateProvider;
import com.voxelpartum.minestuck_extended.MinestuckExtended;
import com.voxelpartum.minestuck_extended.block.MSEBlocks;
import com.voxelpartum.minestuck_extended.block.PlushBlock;
import com.voxelpartum.minestuck_extended.compat.farmers_delight.FDCompatBlocks;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import vectorwing.farmersdelight.common.block.CabinetBlock;

public class MSEBlockstateProvider
extends BlockStateProvider {
    public MSEBlockstateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "minestuck_extended", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)MSEBlocks.CHESS_TILE.get());
        this.simpleBlock((Block)MSEBlocks.CRACKED_END_STONE_BRICKS.get());
        this.slabWithItem((Supplier<SlabBlock>)MSEBlocks.CRACKED_END_STONE_BRICKS_SLAB, MSEBlocks.CRACKED_END_STONE_BRICKS);
        this.stairsWithItem((Supplier<StairBlock>)MSEBlocks.CRACKED_END_STONE_BRICKS_STAIRS, MSEBlocks.CRACKED_END_STONE_BRICKS);
        this.wallWithItem((Supplier<WallBlock>)MSEBlocks.CRACKED_END_STONE_BRICKS_WALL, MSEBlocks.CRACKED_END_STONE_BRICKS);
        this.simpleHorizontal((Block)MSEBlocks.PLUSH_VRISKA.get());
        this.simpleHorizontal((Block)MSEBlocks.PLUSH_SALAMANDER.get());
        this.simpleHorizontal((Block)MSEBlocks.PLUSH_NAKAGATOR.get());
        this.simpleHorizontal((Block)MSEBlocks.PLUSH_IGUANA.get());
        this.simpleHorizontal((Block)MSEBlocks.PLUSH_TURTLE.get());
        this.simpleHorizontal((Block)MSEBlocks.PLUSH_MUTATED_CAT.get());
        this.simpleHorizontal((Block)MSEBlocks.SCALEMATE_APPLESCAB.get());
        this.simpleHorizontal((Block)MSEBlocks.SCALEMATE_BERRYBREATH.get());
        this.simpleHorizontal((Block)MSEBlocks.SCALEMATE_CINNAMONWHIFF.get());
        this.simpleHorizontal((Block)MSEBlocks.SCALEMATE_HONEYTONGUE.get());
        this.simpleHorizontal((Block)MSEBlocks.SCALEMATE_LEMONSNOUT.get());
        this.simpleHorizontal((Block)MSEBlocks.SCALEMATE_PINESNORT.get());
        this.simpleHorizontal((Block)MSEBlocks.SCALEMATE_PUCEFOOT.get());
        this.simpleHorizontal((Block)MSEBlocks.SCALEMATE_PUMPKINSNUFFLE.get());
        this.simpleHorizontal((Block)MSEBlocks.SCALEMATE_PYRALSPITE.get());
        this.simpleHorizontal((Block)MSEBlocks.SCALEMATE_WITNESS.get());
        this.cabinetBlock((CabinetBlock)FDCompatBlocks.BREATH_CABINET.get(), "breath");
        this.cabinetBlock((CabinetBlock)FDCompatBlocks.LIFE_CABINET.get(), "life");
        this.cabinetBlock((CabinetBlock)FDCompatBlocks.LIGHT_CABINET.get(), "light");
        this.cabinetBlock((CabinetBlock)FDCompatBlocks.TIME_CABINET.get(), "time");
        this.cabinetBlock((CabinetBlock)FDCompatBlocks.HEART_CABINET.get(), "heart");
        this.cabinetBlock((CabinetBlock)FDCompatBlocks.RAGE_CABINET.get(), "rage");
        this.cabinetBlock((CabinetBlock)FDCompatBlocks.BLOOD_CABINET.get(), "blood");
        this.cabinetBlock((CabinetBlock)FDCompatBlocks.DOOM_CABINET.get(), "doom");
        this.cabinetBlock((CabinetBlock)FDCompatBlocks.VOID_CABINET.get(), "void");
        this.cabinetBlock((CabinetBlock)FDCompatBlocks.SPACE_CABINET.get(), "space");
        this.cabinetBlock((CabinetBlock)FDCompatBlocks.MIND_CABINET.get(), "mind");
        this.cabinetBlock((CabinetBlock)FDCompatBlocks.HOPE_CABINET.get(), "hope");
        this.cabinetBlock((CabinetBlock)FDCompatBlocks.CARVED_CABINET.get(), "carved");
        this.cabinetBlock((CabinetBlock)FDCompatBlocks.TREATED_CABINET.get(), "treated");
        this.cabinetBlock((CabinetBlock)FDCompatBlocks.LACQUERED_CABINET.get(), "lacquered");
        this.cabinetBlock((CabinetBlock)FDCompatBlocks.GLOWING_CABINET.get(), "glowing");
        this.cabinetBlock((CabinetBlock)FDCompatBlocks.FROST_CABINET.get(), "frost");
        this.cabinetBlock((CabinetBlock)FDCompatBlocks.RAINBOW_CABINET.get(), "rainbow");
        this.cabinetBlock((CabinetBlock)FDCompatBlocks.END_CABINET.get(), "end");
        this.cabinetBlock((CabinetBlock)FDCompatBlocks.DEAD_CABINET.get(), "dead");
        this.cabinetBlock((CabinetBlock)FDCompatBlocks.CINDERED_CABINET.get(), "cindered");
        this.cabinetBlock((CabinetBlock)FDCompatBlocks.SHADEWOOD_CABINET.get(), "shadewood");
    }

    public void slabWithItem(Supplier<SlabBlock> block, DeferredBlock<?> sourceBlock) {
        this.slabWithItem(block, sourceBlock.getId().getPath(), MSBlockStateProvider.texture(sourceBlock));
    }

    public void slabWithItem(Supplier<SlabBlock> block, String baseName, ResourceLocation texture) {
        this.slabWithItem(block, baseName, texture, texture);
    }

    private void slabWithItem(Supplier<SlabBlock> block, String baseName, ResourceLocation side, ResourceLocation topBottom) {
        ModelBuilder slabBottom = this.models().slab(baseName + "_slab", side, topBottom, topBottom);
        ModelBuilder slabTop = this.models().slabTop(baseName + "_slab_top", side, topBottom, topBottom);
        ModelFile.ExistingModelFile doubleSlab = this.models().getExistingFile(MinestuckExtended.id(baseName));
        this.slabBlock(block.get(), (ModelFile)slabBottom, (ModelFile)slabTop, (ModelFile)doubleSlab);
        this.simpleBlockItem((Block)block.get(), (ModelFile)slabBottom);
    }

    public void stairsWithItem(Supplier<StairBlock> block, DeferredBlock<?> sourceBlock) {
        this.stairsWithItem(block, sourceBlock.getId().getPath(), MSBlockStateProvider.texture(sourceBlock));
    }

    void stairsWithItem(Supplier<StairBlock> block, String baseName, ResourceLocation texture) {
        this.stairsWithItem(block, baseName, texture, texture, texture);
    }

    private void stairsWithItem(Supplier<StairBlock> block, String baseName, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        ModelBuilder stairs = this.models().stairs(baseName + "_stairs", side, bottom, top);
        ModelBuilder stairsInner = this.models().stairsInner(baseName + "_inner_stairs", side, bottom, top);
        ModelBuilder stairsOuter = this.models().stairsOuter(baseName + "_outer_stairs", side, bottom, top);
        this.stairsBlock(block.get(), (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
        this.simpleBlockItem((Block)block.get(), (ModelFile)stairs);
    }

    void wallWithItem(Supplier<WallBlock> block, DeferredBlock<?> sourceBlock) {
        this.wallWithItem(block, sourceBlock.getId().getPath(), MSBlockStateProvider.texture(sourceBlock));
    }

    public void wallWithItem(Supplier<WallBlock> block, String baseName, ResourceLocation texture) {
        this.wallBlock(block.get(), texture);
        ModelBuilder wallInventory = this.models().wallInventory(baseName + "_wall_inventory", texture);
        this.simpleBlockItem((Block)block.get(), (ModelFile)wallInventory);
    }

    public void cabinetBlock(CabinetBlock block, String type) {
        this.horizontalBlock((Block)block, state -> {
            String suffix = (Boolean)state.getValue((Property)CabinetBlock.OPEN) != false ? "_open" : "";
            return this.models().orientable(this.blockName((Block)block) + suffix, ResourceLocation.fromNamespaceAndPath((String)"minestuck_extended", (String)("block/" + type + "_cabinet_side")), ResourceLocation.fromNamespaceAndPath((String)"minestuck_extended", (String)("block/" + type + "_cabinet_front" + suffix)), ResourceLocation.fromNamespaceAndPath((String)"minestuck_extended", (String)("block/" + type + "_cabinet_top")));
        });
    }

    public void simpleHorizontal(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"minestuck_extended", (String)("block/" + this.blockName(block))))).rotationY(((int)((Direction)state.getValue(PlushBlock.HORIZONTAL_FACING)).toYRot() + 180) % 360).build());
    }

    private String blockName(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
    }
}

