/*
 * Decompiled with CFR 0.152.
 */
package com.voxelpartum.minestuck_extended.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mraof.minestuck.computer.theme.ComputerTheme;
import com.voxelpartum.minestuck_extended.client.MSEComputerThemes;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public class MSEComputerThemeProvider
implements DataProvider {
    private final Map<ResourceLocation, ComputerTheme.Data> computerThemes = new HashMap<ResourceLocation, ComputerTheme.Data>();
    private final PackOutput output;

    public MSEComputerThemeProvider(PackOutput output) {
        this.output = output;
    }

    protected void add(ResourceLocation id, int textColor) {
        ResourceLocation textureLocation = id.withPath(name -> "textures/gui/theme/" + name + ".png");
        this.add(id, new ComputerTheme.Data(textureLocation, textColor));
    }

    protected void add(ResourceLocation id, ComputerTheme.Data data) {
        this.computerThemes.put(id, data);
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        this.add(MSEComputerThemes.BONER, 16742411);
        Path outputPath = this.output.getOutputFolder(PackOutput.Target.RESOURCE_PACK);
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(this.computerThemes.size());
        for (Map.Entry<ResourceLocation, ComputerTheme.Data> entry : this.computerThemes.entrySet()) {
            Path themePath = MSEComputerThemeProvider.getPath(outputPath, entry.getKey());
            JsonElement encodedTheme = (JsonElement)ComputerTheme.Data.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).getOrThrow();
            futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)encodedTheme, (Path)themePath));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private static Path getPath(Path outputPath, ResourceLocation id) {
        return outputPath.resolve(id.getNamespace() + "/minestuck/computer_themes/" + id.getPath() + ".json");
    }

    public String getName() {
        return "MSE Computer Themes";
    }
}

