/*
 * Decompiled with CFR 0.152.
 */
package com.voxelpartum.minestuck_extended.data;

import com.mraof.minestuck.data.tag.MinestuckBlockTagsProvider;
import com.voxelpartum.minestuck_extended.data.MSEBlockstateProvider;
import com.voxelpartum.minestuck_extended.data.MSEComputerThemeProvider;
import com.voxelpartum.minestuck_extended.data.MSEItemProvider;
import com.voxelpartum.minestuck_extended.data.loot_modifiers.MSEGlobalLootModifierProvider;
import com.voxelpartum.minestuck_extended.data.loot_tables.FDCompatBlockLoot;
import com.voxelpartum.minestuck_extended.data.loot_tables.MSEBlockLoot;
import com.voxelpartum.minestuck_extended.data.loot_tables.chest_loot.MSELootSubProvider;
import com.voxelpartum.minestuck_extended.data.loot_tables.chest_loot.MSELootTableProvider;
import com.voxelpartum.minestuck_extended.data.recipe.MSERecipeProvider;
import com.voxelpartum.minestuck_extended.data.tag.MSEBlockTagsProvider;
import com.voxelpartum.minestuck_extended.data.tag.MSEItemTagsProvider;
import com.voxelpartum.minestuck_extended.trim.MSEArmorTrimMaterials;
import com.voxelpartum.minestuck_extended.trim.MSEArmorTrimPattern;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="minestuck_extended", bus=EventBusSubscriber.Bus.MOD)
public final class MinestuckExtendedData {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput pOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        DatapackBuiltinEntriesProvider builtinEntries = (DatapackBuiltinEntriesProvider)generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(pOutput, event.getLookupProvider(), MinestuckExtendedData.registrySetBuilder(), Set.of("minestuck_extended")));
        CompletableFuture lookupProvider = builtinEntries.getRegistryProvider();
        MinestuckBlockTagsProvider blockTags = (MinestuckBlockTagsProvider)generator.addProvider(event.includeServer(), (DataProvider)new MinestuckBlockTagsProvider(pOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new MSEBlockstateProvider(pOutput, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new MSEItemTagsProvider(pOutput, event.getLookupProvider(), blockTags.contentsGetter(), fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new MSEBlockTagsProvider(pOutput, event.getLookupProvider(), fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new MSERecipeProvider(pOutput, event.getLookupProvider()));
        generator.addProvider(event.includeClient(), (DataProvider)new MSEItemProvider(pOutput, fileHelper));
        generator.addProvider(event.includeServer(), o -> new MSELootTableProvider(o, lookupProvider, List.of(new LootTableProvider.SubProviderEntry(MSEBlockLoot::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(FDCompatBlockLoot::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(MSELootSubProvider::new, LootContextParamSets.CHEST))));
        generator.addProvider(event.includeServer(), (DataProvider)new MSEGlobalLootModifierProvider(pOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new MSEComputerThemeProvider(pOutput));
    }

    private static RegistrySetBuilder registrySetBuilder() {
        return new RegistrySetBuilder().add(Registries.TRIM_MATERIAL, MSEArmorTrimMaterials::bootstrap).add(Registries.TRIM_PATTERN, MSEArmorTrimPattern::bootstrap);
    }
}

