/*
 * Decompiled with CFR 0.152.
 */
package com.voxelpartum.minestuck_extended.data.loot_modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.world.lands.LandTypePair;
import com.mraof.minestuck.world.lands.LandTypes;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import com.mraof.minestuck.world.lands.title.TitleLandType;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class MSELootModifier
extends LootModifier {
    public final ResourceLocation inject;
    public final ResourceLocation target;
    private final Optional<TerrainLandType> terrain;
    private final Optional<TitleLandType> title;
    public static final MapCodec<MSELootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ResourceLocation.CODEC.fieldOf("inject").forGetter(e -> e.inject), (App)ResourceLocation.CODEC.fieldOf("target").forGetter(e -> e.target), (App)LandTypes.TERRAIN_REGISTRY.byNameCodec().optionalFieldOf("terrain").forGetter(e -> e.terrain), (App)LandTypes.TITLE_REGISTRY.byNameCodec().optionalFieldOf("title").forGetter(e -> e.title))).apply((Applicative)inst, MSELootModifier::new));

    protected MSELootModifier(LootItemCondition[] conditionsIn, ResourceLocation inject, ResourceLocation target, Optional<TerrainLandType> terrain, Optional<TitleLandType> title) {
        super(conditionsIn);
        this.inject = inject;
        this.target = target;
        this.title = title;
        this.terrain = terrain;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, @NotNull LootContext context) {
        boolean terrain_correct;
        TitleLandType title = MSELootModifier.getTitle(context);
        TerrainLandType terrain = MSELootModifier.getTerrain(context);
        boolean title_correct = this.title.isEmpty() || this.title.get() == title;
        boolean bl = terrain_correct = this.terrain.isEmpty() || this.terrain.get() == terrain;
        if (title_correct && terrain_correct && context.getQueriedLootTableId().equals((Object)this.target)) {
            generatedLoot.addAll(MSELootModifier.runTable(context.getLevel(), this.inject));
        }
        return generatedLoot;
    }

    @Nullable
    public static TitleLandType getTitle(@Nonnull LootContext context) {
        LandTypePair aspects = LandTypePair.getTypes((ServerLevel)context.getLevel()).orElse(null);
        if (aspects != null) {
            return aspects.getTitle();
        }
        return null;
    }

    @Nullable
    public static TerrainLandType getTerrain(@Nonnull LootContext context) {
        LandTypePair aspects = LandTypePair.getTypes((ServerLevel)context.getLevel()).orElse(null);
        if (aspects != null) {
            return aspects.getTerrain();
        }
        return null;
    }

    public static ObjectArrayList<ItemStack> runTable(ServerLevel level, ResourceLocation loot_table) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)loot_table);
        LootTable table = level.getServer().reloadableRegistries().getLootTable(key);
        LootParams.Builder builder = new LootParams.Builder(level);
        LootParams params = builder.create(LootContextParamSet.builder().build());
        return table.getRandomItems(params);
    }
}

