/*
 * Decompiled with CFR 0.152.
 */
package com.voxelpartum.minestuck_extended.data.tag;

import com.mraof.minestuck.item.MSItemTypes;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.weapon.MSToolType;
import com.mraof.minestuck.item.weapon.MagicRangedRightClickEffect;
import com.mraof.minestuck.item.weapon.WeaponItem;
import com.mraof.minestuck.item.weapon.projectiles.ConsumableProjectileWeaponItem;
import com.mraof.minestuck.util.MSTags;
import com.simibubi.create.AllTags;
import com.voxelpartum.minestuck_extended.compat.farmers_delight.FDCompatItems;
import com.voxelpartum.minestuck_extended.item.MSEItems;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import vectorwing.farmersdelight.common.tag.CommonTags;
import vectorwing.farmersdelight.common.tag.ModTags;

public class MSEItemTagsProvider
extends ItemTagsProvider {
    public MSEItemTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, blockTagProvider, "minestuck_extended", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        List<MSToolType> minestuckextendedMiningToolTypes = List.of(MSItemTypes.SICKLE_TOOL, MSItemTypes.SCYTHE_TOOL, MSItemTypes.CLAWS_TOOL, MSItemTypes.HAMMER_TOOL, MSItemTypes.FORK_TOOL);
        List<MSToolType> minestuckMeleeExtendedToolTypes = List.of(MSItemTypes.LANCE_TOOL, MSItemTypes.CLUB_TOOL, MSItemTypes.KNIFE_TOOL, MSItemTypes.KEY_TOOL, MSItemTypes.FAN_TOOL, MSItemTypes.BATON_TOOL, MSItemTypes.STAFF_TOOL, MSItemTypes.CANE_TOOL, MSItemTypes.WAND_TOOL);
        List minestuckExtendedToolTypes = Stream.concat(minestuckextendedMiningToolTypes.stream(), minestuckMeleeExtendedToolTypes.stream()).toList();
        this.tag(ItemTags.BOOKSHELF_BOOKS).add((Object)((Item)MSItems.CAPTCHA_CARD.get()));
        this.tag(CommonTags.CROPS_ONION).add((Object)((Item)MSItems.ONION.get()));
        this.tag(Tags.Items.TOOLS_SHIELD).add((Object)((Item)MSEItems.SHEELD.get())).add((Object)((Item)MSEItems.POGO_SHIELD.get())).add((Object)((Item)MSEItems.MAGNET_SHIELD.get()));
        this.tag(MSTags.Items.MODUS_CARD).add((Object)((Item)MSEItems.ROULETTE_CARD.get())).add((Object)((Item)MSEItems.ZIP_CARD.get())).add((Object)((Item)MSEItems.ARRAY_CARD.get()));
        this.tag(ItemTags.SWORDS).add((Object[])MSEItemTagsProvider.relevantWeapons(item -> MSEItemTagsProvider.hasToolType(item, List.of(MSItemTypes.SWORD_TOOL))));
        this.tag(ItemTags.AXES).add((Object[])MSEItemTagsProvider.relevantWeapons(item -> MSEItemTagsProvider.hasToolType(item, List.of(MSItemTypes.AXE_TOOL))));
        this.tag(ItemTags.SHOVELS).add((Object[])MSEItemTagsProvider.relevantWeapons(item -> MSEItemTagsProvider.hasToolType(item, List.of(MSItemTypes.SHOVEL_TOOL))));
        this.tag(ItemTags.BREAKS_DECORATED_POTS).add((Object[])MSEItemTagsProvider.relevantWeapons(item -> MSEItemTagsProvider.hasToolType(item, minestuckExtendedToolTypes)));
        this.tag(Tags.Items.MELEE_WEAPON_TOOLS).add((Object[])MSEItemTagsProvider.relevantWeapons(item -> item instanceof WeaponItem));
        this.tag(Tags.Items.TOOLS_SPEAR).add((Object[])MSEItemTagsProvider.relevantWeapons(item -> MSEItemTagsProvider.hasToolType(item, List.of(MSItemTypes.LANCE_TOOL))));
        this.tag(Tags.Items.RANGED_WEAPON_TOOLS).add((Object[])MSEItemTagsProvider.relevantWeapons(item -> {
            WeaponItem weapon;
            return item instanceof ConsumableProjectileWeaponItem || item instanceof WeaponItem && (weapon = (WeaponItem)item).getItemRightClickEffect() instanceof MagicRangedRightClickEffect;
        }));
        this.tag(ItemTags.DURABILITY_ENCHANTABLE).add((Object[])MSEItemTagsProvider.relevantWeapons(item -> item instanceof WeaponItem && item.isDamageable(item.getDefaultInstance())));
        this.tag(ItemTags.MINING_ENCHANTABLE).add((Object[])MSEItemTagsProvider.relevantWeapons(item -> MSEItemTagsProvider.hasToolType(item, minestuckextendedMiningToolTypes)));
        this.tag(ItemTags.MINING_LOOT_ENCHANTABLE).add((Object[])MSEItemTagsProvider.relevantWeapons(item -> MSEItemTagsProvider.hasToolType(item, minestuckextendedMiningToolTypes)));
        this.tag(ItemTags.SWORD_ENCHANTABLE).add((Object[])MSEItemTagsProvider.relevantWeapons(item -> item instanceof WeaponItem));
        this.tag(ItemTags.VANISHING_ENCHANTABLE).add((Object[])MSEItemTagsProvider.relevantWeapons(item -> item instanceof WeaponItem));
        this.tag(ItemTags.TRIM_MATERIALS).add((Object)((Item)MSItems.RAW_CRUXITE.get())).add((Object)((Item)MSItems.RAW_URANIUM.get())).add((Object)((Item)MSItems.BI_DYE.get()));
        this.tag(ItemTags.TRIM_TEMPLATES).add((Object)((Item)MSEItems.SPIROGRAPH_ARMOR_TRIM.get())).add((Object)((Item)MSEItems.BREATH_ARMOR_TRIM.get())).add((Object)((Item)MSEItems.LIFE_ARMOR_TRIM.get())).add((Object)((Item)MSEItems.LIGHT_ARMOR_TRIM.get())).add((Object)((Item)MSEItems.TIME_ARMOR_TRIM.get())).add((Object)((Item)MSEItems.HEART_ARMOR_TRIM.get())).add((Object)((Item)MSEItems.RAGE_ARMOR_TRIM.get())).add((Object)((Item)MSEItems.BLOOD_ARMOR_TRIM.get())).add((Object)((Item)MSEItems.DOOM_ARMOR_TRIM.get())).add((Object)((Item)MSEItems.VOID_ARMOR_TRIM.get())).add((Object)((Item)MSEItems.SPACE_ARMOR_TRIM.get())).add((Object)((Item)MSEItems.MIND_ARMOR_TRIM.get())).add((Object)((Item)MSEItems.HOPE_ARMOR_TRIM.get()));
        this.tag(CommonTags.TOOLS_KNIFE).add((Object)((Item)MSItems.DAGGER.get())).add((Object)((Item)MSItems.DIAMOND_DAGGER.get())).add((Object)((Item)MSItems.PIGLINS_PRIDE.get())).add((Object)((Item)MSItems.BASILISK_BREATH_DRAGONSLAYER.get())).add((Object)((Item)MSItems.HALLOWED_SKEWER.get())).add((Object)((Item)MSItems.GENESIS_GODSTABBER.get())).add((Object)((Item)MSItems.LIGHT_OF_MY_KNIFE.get())).add((Object)((Item)MSItems.THOUSAND_DEGREE_KNIFE.get())).add((Object)((Item)MSItems.STARSHARD_TRI_BLADE.get())).add((Object)((Item)MSItems.TOOTHRIPPER.get())).add((Object)((Item)MSItems.SHADOWRAZOR.get())).add((Object)((Item)MSItems.PRINCESS_PERIL.get()));
        this.tag(AllTags.AllItemTags.CHAIN_RIDEABLE.tag).add((Object)((Item)MSItems.SCYTHE.get())).add((Object)((Item)MSItems.MARASCHINO_CHERRY_SCYTHE.get())).add((Object)((Item)MSItems.KISSY_CUTIE_HEART_SPLITTER.get())).add((Object)((Item)MSItems.MUTANT_CUTIE_CELL_CUTTER.get())).add((Object)((Item)MSItems.PROSPECTING_PICKSCYTHE.get())).add((Object)((Item)MSItems.EIGHTBALL_SCYTHE.get())).add((Object)((Item)MSItems.TIME_FLAYER.get())).add((Object)((Item)MSItems.DESTINY_DECIMATOR.get())).add((Object)((Item)MSItems.SUNRAY_HARVESTER.get())).add((Object)((Item)MSItems.GREEN_SUN_RAYREAPER.get())).add((Object)((Item)MSItems.SKAITHE.get())).add((Object)((Item)MSItems.HELLBRINGERS_HOE_ACTIVE.get())).add((Object)((Item)MSItems.HELLBRINGERS_HOE_INACTIVE.get())).add((Object)((Item)MSEItems.SEAGRIFT_SCYTHE.get()));
        this.tag(ModTags.CABINETS).add((Object)FDCompatItems.BREATH_CABINET.get()).add((Object)FDCompatItems.LIFE_CABINET.get()).add((Object)FDCompatItems.LIGHT_CABINET.get()).add((Object)FDCompatItems.TIME_CABINET.get()).add((Object)FDCompatItems.HEART_CABINET.get()).add((Object)FDCompatItems.RAGE_CABINET.get()).add((Object)FDCompatItems.BLOOD_CABINET.get()).add((Object)FDCompatItems.DOOM_CABINET.get()).add((Object)FDCompatItems.VOID_CABINET.get()).add((Object)FDCompatItems.SPACE_CABINET.get()).add((Object)FDCompatItems.MIND_CABINET.get()).add((Object)FDCompatItems.HOPE_CABINET.get()).add((Object)FDCompatItems.CARVED_CABINET.get()).add((Object)FDCompatItems.TREATED_CABINET.get()).add((Object)FDCompatItems.LACQUERED_CABINET.get()).add((Object)FDCompatItems.GLOWING_CABINET.get()).add((Object)FDCompatItems.FROST_CABINET.get()).add((Object)FDCompatItems.RAINBOW_CABINET.get()).add((Object)FDCompatItems.END_CABINET.get()).add((Object)FDCompatItems.DEAD_CABINET.get()).add((Object)FDCompatItems.CINDERED_CABINET.get()).add((Object)FDCompatItems.SHADEWOOD_CABINET.get());
        this.tag(MSTags.Items.UNREADABLE).add((Object)Items.HEAVY_CORE).add((Object)Items.MACE);
    }

    private static Item[] relevantWeapons(Predicate<Item> predicate) {
        return (Item[])MSEItems.REGISTER.getEntries().stream().map(Supplier::get).filter(predicate).toArray(Item[]::new);
    }

    private static boolean hasToolType(Item item, List<MSToolType> toolTypes) {
        WeaponItem weaponItem;
        if (!(item instanceof WeaponItem) || (weaponItem = (WeaponItem)item).getToolTypes() == null) {
            return false;
        }
        List weaponTypes = weaponItem.getToolTypes();
        for (MSToolType toolType : toolTypes) {
            if (!weaponTypes.contains(toolType)) continue;
            return true;
        }
        return false;
    }
}

