/*
 * Decompiled with CFR 0.152.
 */
package com.voxelpartum.minestuck_extended.inventory.captchalogue;

import com.mraof.minestuck.inventory.captchalogue.CaptchaDeckHandler;
import com.mraof.minestuck.inventory.captchalogue.ModusType;
import com.mraof.minestuck.item.CaptchaCardItem;
import com.mraof.minestuck.item.MSItems;
import com.voxelpartum.minestuck_extended.MinestuckExtendedConfig;
import com.voxelpartum.minestuck_extended.inventory.captchalogue.BaseModus;
import com.voxelpartum.minestuck_extended.item.MSEItems;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.LogicalSide;

public class ZipModus
extends BaseModus {
    public ZipModus(ModusType<? extends BaseModus> type, LogicalSide side) {
        super(type, side);
    }

    @Override
    public boolean putItemStack(ServerPlayer player, ItemStack item) {
        if (this.size <= this.list.size() || item.isEmpty()) {
            return false;
        }
        for (ItemStack stack : this.list) {
            if (stack.getItem() != item.getItem()) continue;
            CaptchaDeckHandler.launchItem((ServerPlayer)player, (ItemStack)item);
            return true;
        }
        this.list.add((Object)item);
        this.markDirty();
        return true;
    }

    @Override
    public ItemStack getItem(ServerPlayer player, int id, boolean asCard) {
        if (id == -2) {
            if (this.list.size() < this.size) {
                --this.size;
                this.markDirty();
                return new ItemStack((ItemLike)MSItems.CAPTCHA_CARD.get());
            }
            return ItemStack.EMPTY;
        }
        if (this.list.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (id == -1) {
            for (ItemStack item : this.list) {
                CaptchaDeckHandler.launchAnyItem((Player)player, (ItemStack)item);
            }
            this.list.clear();
            this.markDirty();
            return ItemStack.EMPTY;
        }
        if (id < 0 || id >= this.list.size()) {
            return ItemStack.EMPTY;
        }
        NonNullList gottenItems = NonNullList.create();
        int maxBack = Math.max(0, id - (Integer)MinestuckExtendedConfig.SERVER.zipSize.get());
        int maxFront = Math.min(this.list.size() - 1, id + (Integer)MinestuckExtendedConfig.SERVER.zipSize.get());
        for (int i = 0; i < maxFront - maxBack + 1; ++i) {
            gottenItems.add((Object)(asCard ? CaptchaCardItem.createCardWithItem((ItemStack)((ItemStack)this.list.remove(maxBack)), (MinecraftServer)player.server) : (ItemStack)this.list.remove(maxBack)));
        }
        if (asCard) {
            this.size -= gottenItems.size();
        }
        this.markDirty();
        ItemStack zipItem = new ItemStack((ItemLike)MSEItems.ZIP_BUNDLE.get());
        zipItem.set(DataComponents.BUNDLE_CONTENTS, (Object)new BundleContents((List)gottenItems));
        return zipItem;
    }
}

