/*
 * Decompiled with CFR 0.152.
 */
package com.voxelpartum.minestuck_extended.item;

import com.voxelpartum.minestuck_extended.MinestuckExtendedConfig;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.math.Fraction;

public class ZipBundleItem
extends Item {
    private static final int BAR_COLOR = 12197966;

    public ZipBundleItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemstack = player.getItemInHand(usedHand);
        if (ZipBundleItem.dropContents(itemstack, player)) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)ItemStack.EMPTY, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    private static boolean dropContents(ItemStack stack, Player player) {
        BundleContents zipBundlecontents = (BundleContents)stack.get(DataComponents.BUNDLE_CONTENTS);
        if (zipBundlecontents != null) {
            stack.set(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY);
            if (player instanceof ServerPlayer) {
                if (player.isShiftKeyDown()) {
                    zipBundlecontents.itemsCopy().forEach(itemStack -> player.drop(itemStack, true));
                } else {
                    zipBundlecontents.itemsCopy().forEach(itemStack -> player.getInventory().placeItemBackInInventory(itemStack.copy()));
                }
            }
            return true;
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (stack.getCount() != 1) {
            return false;
        }
        if (action == ClickAction.SECONDARY && slot.allowModification(player)) {
            ItemStack itemstack;
            BundleContents bundlecontents = (BundleContents)stack.get(DataComponents.BUNDLE_CONTENTS);
            if (bundlecontents == null) {
                return false;
            }
            BundleContents.Mutable bundlecontents$mutable = new BundleContents.Mutable(bundlecontents);
            if (other.isEmpty() && ((Boolean)MinestuckExtendedConfig.SERVER.pullSingleItemZipBundle.get()).booleanValue() && (itemstack = bundlecontents$mutable.removeOne()) != null) {
                this.playRemoveOneSound((Entity)player);
                access.set(itemstack);
            }
            stack.set(DataComponents.BUNDLE_CONTENTS, (Object)bundlecontents$mutable.toImmutable());
            return true;
        }
        return false;
    }

    private void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    public boolean isBarVisible(ItemStack stack) {
        BundleContents bundlecontents = (BundleContents)stack.getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY);
        return bundlecontents.weight().compareTo(Fraction.ZERO) > 0;
    }

    public int getBarWidth(ItemStack stack) {
        BundleContents bundlecontents = (BundleContents)stack.getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY);
        return Math.min(1 + Mth.mulAndTruncate((Fraction)bundlecontents.weight(), (int)12), 13);
    }

    public int getBarColor(ItemStack stack) {
        return 12197966;
    }

    public void onDestroyed(ItemEntity itemEntity) {
        BundleContents zipBundlecontents = (BundleContents)itemEntity.getItem().get(DataComponents.BUNDLE_CONTENTS);
        if (zipBundlecontents != null) {
            itemEntity.getItem().set(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY);
            ItemUtils.onContainerDestroyed((ItemEntity)itemEntity, (Iterable)zipBundlecontents.itemsCopy());
        }
    }
}

