/*
 * Decompiled with CFR 0.152.
 */
package com.voxelpartum.minestuck_extended.item.projectile;

import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.entity.item.ConsumableProjectileEntity;
import com.mraof.minestuck.item.weapon.projectiles.ConsumableProjectileWeaponItem;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MSEConsumableProjectile
extends ConsumableProjectileWeaponItem {
    public final SoundEvent sound;

    public MSEConsumableProjectile(Item.Properties properties, float velocity, float accuracy, int damage, SoundEvent sound) {
        super(properties, velocity, accuracy, damage);
        this.sound = sound;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack item = playerIn.getItemInHand(handIn);
        level.playSound(playerIn, playerIn.getX(), playerIn.getY(), playerIn.getZ(), this.sound, SoundSource.PLAYERS, 0.65f, 1.0f);
        if (!level.isClientSide) {
            ConsumableProjectileEntity projectileEntity = new ConsumableProjectileEntity((EntityType)MSEntityTypes.CONSUMABLE_PROJECTILE.get(), (LivingEntity)playerIn, level);
            projectileEntity.setItem(item);
            projectileEntity.shootFromRotation((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), 0.0f, this.velocity, this.accuracy);
            level.addFreshEntity((Entity)projectileEntity);
        }
        if (!playerIn.isCreative()) {
            item.shrink(1);
        }
        playerIn.getCooldowns().addCooldown((Item)this, 7);
        playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.success((Object)item);
    }
}

