/*
 * Decompiled with CFR 0.152.
 */
package com.voxelpartum.minestuck_extended.item.weapon;

import com.mraof.minestuck.item.weapon.WeaponItem;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class MaceWeaponItem
extends WeaponItem {
    public MaceWeaponItem(WeaponItem.Builder builder, Item.Properties properties) {
        super(builder, properties);
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        if (MaceWeaponItem.canSmashAttack(attacker)) {
            attacker.resetFallDistance();
        }
    }

    public float getAttackDamageBonus(Entity target, float damage, DamageSource damageSource) {
        Entity entity = damageSource.getDirectEntity();
        if (entity instanceof LivingEntity) {
            float f;
            LivingEntity livingentity = (LivingEntity)entity;
            if (!MaceWeaponItem.canSmashAttack(livingentity)) {
                return 0.0f;
            }
            float f3 = 3.0f;
            float f2 = 8.0f;
            float f1 = livingentity.fallDistance;
            float f22 = f1 <= 3.0f ? 4.0f * f1 : (f1 <= 8.0f ? 12.0f + 2.0f * (f1 - 3.0f) : 22.0f + f1 - 8.0f);
            Level level = livingentity.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                f = f22 + EnchantmentHelper.modifyFallBasedDamage((ServerLevel)serverlevel, (ItemStack)livingentity.getWeaponItem(), (Entity)target, (DamageSource)damageSource, (float)0.0f) * f1;
            } else {
                f = f22;
            }
            return f;
        }
        return 0.0f;
    }

    public static boolean canSmashAttack(LivingEntity entity) {
        return entity.fallDistance > 1.5f && !entity.isFallFlying();
    }
}

