/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.base.spark;

import com.drmangotea.tfmg.base.spark.AbstractSpark;
import com.drmangotea.tfmg.base.spark.FireSpark;
import com.drmangotea.tfmg.content.items.weapons.explosives.thermite_grenades.fire.GreenFireBlock;
import com.simibubi.create.content.trains.CubeParticleData;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class GreenSpark
extends FireSpark {
    public GreenSpark(EntityType<? extends AbstractSpark> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            CubeParticleData data = new CubeParticleData(0.01f, 100.25f, 20.1f, 0.0125f + 0.0625f * this.random.nextFloat(), 30, true);
            this.level().addParticle((ParticleOptions)data, this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.05, -this.getDeltaMovement().y * 0.5, this.random.nextGaussian() * 0.05);
        }
    }

    @Override
    public Optional<SimpleParticleType> getParticleEffect() {
        return Optional.empty();
    }

    @Override
    public void spawnFire(BlockHitResult blockHitResult) {
        Entity entity;
        if (!this.level().isClientSide && !((entity = this.getOwner()) instanceof Mob)) {
            BlockPos blockpos = blockHitResult.getBlockPos().relative(blockHitResult.getDirection());
            if (this.level().isEmptyBlock(blockpos)) {
                this.level().setBlockAndUpdate(blockpos, GreenFireBlock.getState((BlockGetter)this.level(), blockpos));
            }
        }
    }
}

