/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.decoration.pipes;

import com.drmangotea.tfmg.base.TFMGRegistrate;
import com.drmangotea.tfmg.config.TFMGStress;
import com.drmangotea.tfmg.content.decoration.pipes.TFMGEncasedPipeBlock;
import com.drmangotea.tfmg.content.decoration.pipes.TFMGFluidValveBlock;
import com.drmangotea.tfmg.content.decoration.pipes.TFMGGlassPipeBlock;
import com.drmangotea.tfmg.content.decoration.pipes.TFMGPipeAttachmentModel;
import com.drmangotea.tfmg.content.decoration.pipes.TFMGPipeBlock;
import com.drmangotea.tfmg.content.decoration.pipes.TFMGPipes;
import com.drmangotea.tfmg.content.decoration.pipes.TFMGPumpBlock;
import com.drmangotea.tfmg.content.decoration.pipes.TFMGSmartFluidPipeBlock;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.decoration.encasing.EncasedCTBehaviour;
import com.simibubi.create.content.decoration.encasing.EncasingRegistry;
import com.simibubi.create.content.fluids.PipeAttachmentModel;
import com.simibubi.create.content.fluids.pipes.SmartFluidPipeGenerator;
import com.simibubi.create.content.fluids.pipes.valve.FluidValveBlock;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.data.AssetLookup;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.ModelGen;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class TFMGPipeEntry {
    private final TFMGPipes.PipeMaterial material;
    private final TFMGRegistrate registrate;
    private final BlockEntry<? extends TFMGPipeBlock> pipe;
    private final BlockEntry<? extends TFMGEncasedPipeBlock> encased;
    private final BlockEntry<? extends TFMGGlassPipeBlock> glass;
    private final BlockEntry<? extends TFMGPumpBlock> pump;
    private final BlockEntry<? extends TFMGSmartFluidPipeBlock> smart;
    private final BlockEntry<? extends TFMGFluidValveBlock> valve;
    private CTSpriteShiftEntry encasedSpriteShift;

    public TFMGPipeEntry(TFMGPipes.PipeMaterial material, TFMGRegistrate registrate) {
        this.material = material;
        this.registrate = registrate;
        this.pipe = this.registerPipe();
        this.encased = this.registerEncasedPipe();
        this.glass = this.registerGlassPipe();
        this.pump = this.registerPump();
        this.smart = this.registerSmartPipe();
        this.valve = this.registerValve();
    }

    public TFMGPipeEntry encasedSpriteShift(CTSpriteShiftEntry encasedSpriteShift) {
        this.encasedSpriteShift = encasedSpriteShift;
        return this;
    }

    public BlockEntry<? extends TFMGPipeBlock> getPipe() {
        return this.pipe;
    }

    public BlockEntry<? extends TFMGEncasedPipeBlock> getEncased() {
        return this.encased;
    }

    public BlockEntry<? extends TFMGGlassPipeBlock> getGlass() {
        return this.glass;
    }

    public BlockEntry<? extends TFMGPumpBlock> getPump() {
        return this.pump;
    }

    public BlockEntry<? extends TFMGSmartFluidPipeBlock> getSmart() {
        return this.smart;
    }

    public BlockEntry<? extends TFMGFluidValveBlock> getValve() {
        return this.valve;
    }

    protected BlockEntry<? extends TFMGPipeBlock> registerPipe() {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)this.registrate.block(this.material.name + "_pipe", p -> new TFMGPipeBlock((BlockBehaviour.Properties)p, this.material)).initialProperties(SharedProperties::copperMetal).transform(TagGen.pickaxeOnly())).blockstate(BlockStateGen.pipe()).onRegister(CreateRegistrate.blockModel(() -> switch (this.material) {
            default -> throw new MatchException(null, null);
            case TFMGPipes.PipeMaterial.BRASS -> TFMGPipeAttachmentModel::withAOBrass;
            case TFMGPipes.PipeMaterial.STEEL -> TFMGPipeAttachmentModel::withAOSteel;
            case TFMGPipes.PipeMaterial.ALUMINUM -> TFMGPipeAttachmentModel::withAOAluminum;
            case TFMGPipes.PipeMaterial.CAST_IRON -> TFMGPipeAttachmentModel::withAOCastIron;
            case TFMGPipes.PipeMaterial.PLASTIC -> TFMGPipeAttachmentModel::withAOPlastic;
        }))).item().transform(ModelGen.customItemModel())).register();
    }

    protected BlockEntry<? extends TFMGEncasedPipeBlock> registerEncasedPipe() {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)this.registrate.block("copper_encased_" + this.material.name + "_pipe", p -> new TFMGEncasedPipeBlock((BlockBehaviour.Properties)p, () -> ((BlockEntry)AllBlocks.COPPER_CASING).get(), this.material)).initialProperties(SharedProperties::copperMetal).properties(p -> p.noOcclusion().mapColor(MapColor.TERRACOTTA_LIGHT_GRAY)).transform(TagGen.axeOrPickaxe())).blockstate(BlockStateGen.encasedPipe()).onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCTBehaviour(this.encasedSpriteShift)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, this.encasedSpriteShift, (s, f) -> (Boolean)s.getValue((Property)TFMGEncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(f)) == false)))).onRegister(CreateRegistrate.blockModel(() -> PipeAttachmentModel::withoutAO))).loot((p, b) -> p.dropOther((Block)b, (ItemLike)this.pipe.get())).transform((NonNullFunction)EncasingRegistry.addVariantTo(this.pipe))).register();
    }

    protected BlockEntry<? extends TFMGGlassPipeBlock> registerGlassPipe() {
        return ((BlockBuilder)((BlockBuilder)this.registrate.block("glass_" + this.material.name + "_pipe", p -> new TFMGGlassPipeBlock((BlockBehaviour.Properties)p, this.material)).initialProperties(SharedProperties::copperMetal).addLayer(() -> RenderType::cutoutMipped).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> p.getVariantBuilder((Block)c.getEntry()).forAllStatesExcept(state -> {
            Direction.Axis axis = (Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS);
            return ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(p.modLoc("block/" + this.material.name + "_pipe/window"))).uvLock(false).rotationX(axis == Direction.Axis.Y ? 0 : 90).rotationY(axis == Direction.Axis.X ? 90 : 0).build();
        }, new Property[]{BlockStateProperties.WATERLOGGED})).onRegister(CreateRegistrate.blockModel(() -> switch (this.material) {
            default -> throw new MatchException(null, null);
            case TFMGPipes.PipeMaterial.BRASS -> TFMGPipeAttachmentModel::withAOBrass;
            case TFMGPipes.PipeMaterial.STEEL -> TFMGPipeAttachmentModel::withAOSteel;
            case TFMGPipes.PipeMaterial.ALUMINUM -> TFMGPipeAttachmentModel::withAOAluminum;
            case TFMGPipes.PipeMaterial.CAST_IRON -> TFMGPipeAttachmentModel::withAOCastIron;
            case TFMGPipes.PipeMaterial.PLASTIC -> TFMGPipeAttachmentModel::withAOPlastic;
        }))).loot((p, b) -> p.dropOther((Block)b, (ItemLike)this.pipe.get())).register();
    }

    protected BlockEntry<? extends TFMGPumpBlock> registerPump() {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)this.registrate.block(this.material.name + "_mechanical_pump", TFMGPumpBlock::new).initialProperties(SharedProperties::copperMetal).transform(TagGen.pickaxeOnly())).blockstate(BlockStateGen.directionalBlockProviderIgnoresWaterlogged((boolean)true)).onRegister(CreateRegistrate.blockModel(() -> switch (this.material) {
            default -> throw new MatchException(null, null);
            case TFMGPipes.PipeMaterial.BRASS -> TFMGPipeAttachmentModel::withAOBrass;
            case TFMGPipes.PipeMaterial.STEEL -> TFMGPipeAttachmentModel::withAOSteel;
            case TFMGPipes.PipeMaterial.ALUMINUM -> TFMGPipeAttachmentModel::withAOAluminum;
            case TFMGPipes.PipeMaterial.CAST_IRON -> TFMGPipeAttachmentModel::withAOCastIron;
            case TFMGPipes.PipeMaterial.PLASTIC -> TFMGPipeAttachmentModel::withAOPlastic;
        }))).transform(TFMGStress.setImpact(4.0))).item().transform(ModelGen.customItemModel())).register();
    }

    protected BlockEntry<? extends TFMGSmartFluidPipeBlock> registerSmartPipe() {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)this.registrate.block(this.material.name + "_smart_fluid_pipe", TFMGSmartFluidPipeBlock::new).initialProperties(SharedProperties::copperMetal).transform(TagGen.pickaxeOnly())).blockstate((arg_0, arg_1) -> ((SmartFluidPipeGenerator)new SmartFluidPipeGenerator()).generate(arg_0, arg_1)).onRegister(CreateRegistrate.blockModel(() -> switch (this.material) {
            default -> throw new MatchException(null, null);
            case TFMGPipes.PipeMaterial.BRASS -> TFMGPipeAttachmentModel::withAOBrass;
            case TFMGPipes.PipeMaterial.STEEL -> TFMGPipeAttachmentModel::withAOSteel;
            case TFMGPipes.PipeMaterial.ALUMINUM -> TFMGPipeAttachmentModel::withAOAluminum;
            case TFMGPipes.PipeMaterial.CAST_IRON -> TFMGPipeAttachmentModel::withAOCastIron;
            case TFMGPipes.PipeMaterial.PLASTIC -> TFMGPipeAttachmentModel::withAOPlastic;
        }))).item().transform(ModelGen.customItemModel())).register();
    }

    protected BlockEntry<? extends TFMGFluidValveBlock> registerValve() {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)this.registrate.block(this.material.name + "_fluid_valve", TFMGFluidValveBlock::new).initialProperties(SharedProperties::copperMetal).transform(TagGen.pickaxeOnly())).addLayer(() -> RenderType::cutoutMipped).blockstate((c, p) -> BlockStateGen.directionalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, (state, vertical) -> AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[]{vertical != false ? "vertical" : "horizontal", (Boolean)state.getValue((Property)FluidValveBlock.ENABLED) != false ? "open" : "closed"}))).onRegister(CreateRegistrate.blockModel(() -> switch (this.material) {
            default -> throw new MatchException(null, null);
            case TFMGPipes.PipeMaterial.BRASS -> TFMGPipeAttachmentModel::withAOBrass;
            case TFMGPipes.PipeMaterial.STEEL -> TFMGPipeAttachmentModel::withAOSteel;
            case TFMGPipes.PipeMaterial.ALUMINUM -> TFMGPipeAttachmentModel::withAOAluminum;
            case TFMGPipes.PipeMaterial.CAST_IRON -> TFMGPipeAttachmentModel::withAOCastIron;
            case TFMGPipes.PipeMaterial.PLASTIC -> TFMGPipeAttachmentModel::withAOPlastic;
        }))).item().transform(ModelGen.customItemModel())).register();
    }
}

