/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.lights;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.base.blocks.WallMountBlock;
import com.drmangotea.tfmg.content.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.content.electricity.lights.LightBulbBlock;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LightBulbBlockEntity
extends ElectricBlockEntity {
    public LerpedFloat glow = LerpedFloat.linear();
    boolean signalChanged;
    boolean hasSignal;
    public DyeColor color = DyeColor.WHITE;

    public LightBulbBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.hasSignal && this.canWork()) {
            this.glow.chase((double)this.getPowerUsage() * 2.5, 0.4, LerpedFloat.Chaser.EXP);
            this.glow.tickChaser();
            if (Math.min(this.getData().getVoltage() / 10, 15) != (Integer)this.getBlockState().getValue((Property)LightBulbBlock.LIGHT)) {
                this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)LightBulbBlock.LIGHT, (Comparable)Integer.valueOf(Math.min(this.getData().getVoltage() / 10, 15))), 2);
            }
        } else {
            if ((Integer)this.getBlockState().getValue((Property)LightBulbBlock.LIGHT) != 0) {
                this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)LightBulbBlock.LIGHT, (Comparable)Integer.valueOf(0)), 2);
            }
            this.glow.chase(0.0, 0.4, LerpedFloat.Chaser.EXP);
            this.glow.tickChaser();
        }
        if (this.signalChanged) {
            this.signalChanged = false;
            this.analogSignalChanged(this.level.getBestNeighborSignal(this.worldPosition));
        }
    }

    public void setColor(DyeColor color) {
        if (color == DyeColor.BLACK || color == DyeColor.LIGHT_GRAY || color == DyeColor.GRAY) {
            return;
        }
        this.color = color;
        this.notifyUpdate();
    }

    @Override
    public void blockFail() {
        super.blockFail();
        TFMGUtils.playSound(this.level, this.getBlockPos(), SoundEvents.GLASS_BREAK, SoundSource.BLOCKS);
    }

    @Override
    public void setVoltage(int newVoltage) {
        super.setVoltage(newVoltage);
    }

    @Override
    public float resistance() {
        return 100.0f;
    }

    public void neighbourChanged() {
        boolean powered;
        if (!this.hasLevel()) {
            return;
        }
        boolean bl = powered = this.level.getBestNeighborSignal(this.worldPosition) > 0;
        if (powered != this.hasSignal) {
            this.signalChanged = true;
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.neighbourChanged();
    }

    @Override
    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        NBTHelper.writeEnum((CompoundTag)compound, (String)"color", (Enum)this.color);
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.color = (DyeColor)NBTHelper.readEnum((CompoundTag)compound, (String)"color", DyeColor.class);
    }

    @Override
    public boolean canBeInGroups() {
        return true;
    }

    protected void analogSignalChanged(int newSignal) {
        this.hasSignal = newSignal > 0;
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.getBlockState().getValue((Property)WallMountBlock.FACING)).getOpposite();
    }
}

