/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.lights.neon_tube;

import com.drmangotea.tfmg.content.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.content.electricity.lights.LightBulbBlock;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class NeonTubeBlockEntity
extends ElectricBlockEntity {
    public DyeColor color = DyeColor.WHITE;
    public LerpedFloat glow = LerpedFloat.linear();

    public NeonTubeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public boolean canBeInGroups() {
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        this.glow.chase((double)this.getPowerUsage() * 1.5, 0.4, LerpedFloat.Chaser.EXP);
        this.glow.tickChaser();
        if (Math.min(this.getData().getVoltage() / 10, 15) != (Integer)this.getBlockState().getValue((Property)LightBulbBlock.LIGHT)) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)LightBulbBlock.LIGHT, (Comparable)Integer.valueOf(Math.min(this.getData().getVoltage() / 10, 15))), 2);
        }
    }

    @Override
    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        NBTHelper.writeEnum((CompoundTag)compound, (String)"color", (Enum)this.color);
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.color = (DyeColor)NBTHelper.readEnum((CompoundTag)compound, (String)"color", DyeColor.class);
    }

    public void setColor(DyeColor color) {
        if (color == DyeColor.BLACK || color == DyeColor.LIGHT_GRAY || color == DyeColor.GRAY) {
            return;
        }
        this.color = color;
        this.notifyUpdate();
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return (Boolean)this.getBlockState().getValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction));
    }

    @Override
    public float resistance() {
        return 200.0f;
    }
}

