/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.utilities.converter;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.storage.AccumulatorBlockEntity;
import com.drmangotea.tfmg.content.electricity.storage.TFMGForgeEnergyStorage;
import com.drmangotea.tfmg.content.electricity.utilities.converter.ConverterBlock;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class ConverterBlockEntity
extends ElectricBlockEntity {
    public final TFMGForgeEnergyStorage energy = this.createEnergyStorage();
    private IEnergyStorage energyCapability = this.energy;
    public int timer = 0;
    protected ScrollValueBehaviour voltageGenerated;

    public ConverterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TFMGForgeEnergyStorage createEnergyStorage() {
        return new TFMGForgeEnergyStorage(500000, 10000){

            @Override
            public void onEnergyChanged(int amount, int a) {
                ConverterBlockEntity.this.sendStuff();
            }
        };
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)TFMGBlockEntities.CONVERTER.get(), (be, context) -> be.energyCapability);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        int max = 250;
        this.voltageGenerated = new ScrollValueBehaviour((Component)CreateLang.translateDirect((String)"creative_generator.voltage_generation", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new ConverterValueBox());
        this.voltageGenerated.between(1, max);
        this.voltageGenerated.value = 20;
        this.voltageGenerated.withCallback(i -> this.updateNextTick());
        behaviours.add((BlockEntityBehaviour)this.voltageGenerated);
    }

    @Override
    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putInt("ForgeEnergy", this.energy.getEnergyStored());
    }

    public boolean isInput() {
        return (Boolean)this.getBlockState().getValue((Property)ConverterBlock.INPUT);
    }

    @Override
    public float resistance() {
        if (this.voltageGeneration() > 0) {
            return 0.0f;
        }
        int power = 0;
        for (IElectric member : this.getOrCreateElectricNetwork().members) {
            if (member instanceof ConverterBlockEntity || member instanceof AccumulatorBlockEntity) continue;
            power += member.getPowerUsage();
        }
        if (this.energy.getEnergyStored() == this.getMaxCapacity() || this.getData().getVoltage() <= this.voltageGenerated.getValue() || this.canPower()) {
            return 0.0f;
        }
        if (Math.min(Math.max(this.data.networkPowerGeneration - power, 0), this.getMaxChargingRate()) == 0) {
            return 0.0f;
        }
        return (float)(this.data.voltage * this.data.voltage) / (float)Math.min(Math.max(this.data.networkPowerGeneration - power, 0), this.getMaxChargingRate());
    }

    public boolean canPower() {
        if (this.timer != 0) {
            return false;
        }
        if (((Boolean)this.getBlockState().getValue((Property)ConverterBlock.INPUT)).booleanValue()) {
            return false;
        }
        return this.getData().networkResistance > 0 && this.getData().getVoltage() <= this.voltageGenerated.getValue() && this.energy.getEnergyStored() > 0;
    }

    public int getChargingRate() {
        if (this.energy.getEnergyStored() == this.getMaxCapacity() || this.getData().getVoltage() < this.voltageGenerated.value || this.canPower() || this.data.notEnoughtPower) {
            return 0;
        }
        return this.getMaxChargingRate();
    }

    @Override
    public int powerGeneration() {
        if (this.canPower()) {
            return 10000;
        }
        return 0;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.timer > 0) {
            if (this.timer == 1) {
                this.updateNextTick();
            }
            --this.timer;
        }
        if (((Boolean)this.getBlockState().getValue((Property)ConverterBlock.INPUT)).booleanValue()) {
            if (this.getData().getVoltage() > (Integer)TFMGConfigs.common().machines.accumulatorVoltage.get()) {
                this.energy.receiveEnergy((int)((double)this.getChargingRate() / (Double)TFMGConfigs.common().machines.FEtoWattTickConversionRate.get()), false);
            }
        } else if (this.canPower()) {
            int energyToExtract = this.data.networkPowerGeneration == 0 ? this.getNetworkPowerUsage() : (int)Math.max(0.0f, Math.max((float)this.powerGeneration() / (float)this.data.networkPowerGeneration * (float)this.getNetworkPowerUsage(), 0.0f));
            energyToExtract = (int)((double)energyToExtract / (Double)TFMGConfigs.common().machines.FEtoWattTickConversionRate.get());
            this.energy.extractEnergy(Math.max(energyToExtract, 1), false);
            if (this.energy.getEnergyStored() == 0) {
                this.timer = 100;
                this.updateNextTick();
            }
        }
    }

    @Override
    public boolean makeMultimeterTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.makeMultimeterTooltip(tooltip, isPlayerSneaking);
        CreateLang.text((String)"Capacity ").add(Component.literal((String)TFMGUtils.formatUnits(this.energy.getEnergyStored(), "FE"))).color(1210265).forGoggles(tooltip, 1);
        CreateLang.text((String)"Charging Rate ").add(CreateLang.number((double)this.getChargingRate())).color(1210265).forGoggles(tooltip, 1);
        CreateLang.text((String)"Max Capacity ").add(CreateLang.number((double)this.getMaxCapacity())).color(1210265).forGoggles(tooltip, 1);
        return true;
    }

    public int getMaxCapacity() {
        return (Integer)TFMGConfigs.common().machines.accumulatorStorage.get();
    }

    public int getMaxChargingRate() {
        return (Integer)TFMGConfigs.common().machines.accumulatorChargingRate.get() * 10;
    }

    @Override
    public int voltageGeneration() {
        return this.canPower() ? this.voltageGenerated.getValue() : 0;
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.energy.setEnergy(compound.getInt("ForgeEnergy"));
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getClockWise();
    }

    public static class ConverterValueBox
    extends ValueBoxTransform.Sided {
        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)3.0, (double)16.05);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction.getAxis() == ((Direction)state.getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getAxis();
        }
    }
}

