/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.utilities.polarizer;

import com.drmangotea.tfmg.base.TFMGShapes;
import com.drmangotea.tfmg.base.blocks.TFMGHorizontalDirectionalBlock;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.utilities.polarizer.PolarizerBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PolarizerBlock
extends TFMGHorizontalDirectionalBlock
implements IBE<PolarizerBlockEntity> {
    public PolarizerBlock(BlockBehaviour.Properties p_54120_) {
        super(p_54120_);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PolarizerBlockEntity) {
            PolarizerBlockEntity be = (PolarizerBlockEntity)blockEntity;
            if (player.getItemInHand(hand).isEmpty()) {
                if (!be.inventory.isEmpty()) {
                    player.setItemInHand(hand, be.inventory.getStackInSlot(0));
                    be.inventory.setItem(0, ItemStack.EMPTY);
                    return ItemInteractionResult.SUCCESS;
                }
            } else if (be.inventory.isEmpty() && !stack.isEmpty()) {
                ItemStack stack1 = player.getItemInHand(hand).copy();
                stack1.setCount(1);
                be.inventory.setItem(0, stack1);
                player.getItemInHand(hand).shrink(1);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onPlace(BlockState pState, Level level, BlockPos pos, BlockState pOldState, boolean pIsMoving) {
        this.withBlockEntityDo((BlockGetter)level, pos, IElectric::onPlaced);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return TFMGShapes.POLARIZER.get((Direction)state.getValue((Property)FACING));
    }

    public Class<PolarizerBlockEntity> getBlockEntityClass() {
        return PolarizerBlockEntity.class;
    }

    public BlockEntityType<? extends PolarizerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.POLARIZER.get();
    }
}

