/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.utilities.transformer;

import com.drmangotea.tfmg.base.blocks.TFMGHorizontalDirectionalBlock;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.base.UpdateInFrontPacket;
import com.drmangotea.tfmg.content.electricity.base.VoltageAlteringBlockEntity;
import com.drmangotea.tfmg.registry.TFMGDataComponents;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TransformerBlockEntity
extends VoltageAlteringBlockEntity {
    boolean updateInFront = false;
    public ItemStack primaryCoil = ItemStack.EMPTY;
    public ItemStack secondaryCoil = ItemStack.EMPTY;
    public float coilRatio = 0.0f;

    public TransformerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public int getOutputVoltage() {
        return (int)((float)this.getData().getVoltage() * this.coilRatio);
    }

    @Override
    public int getOutputPower() {
        return this.coilRatio == 0.0f ? 0 : this.getPowerUsage();
    }

    @Override
    public IElectric getControlledBlock() {
        IElectric be;
        Direction facing = this.getBlockState().hasProperty((Property)DirectionalBlock.FACING) ? (Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING) : ((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getCounterClockWise();
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId()) {
            return be;
        }
        return null;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.updateInFront) {
            this.updateInFront();
            this.updateInFront = false;
        }
    }

    public void destroy() {
        ItemEntity item;
        super.destroy();
        BlockPos pos = this.getBlockPos();
        if (!this.primaryCoil.isEmpty()) {
            item = new ItemEntity(this.level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), this.primaryCoil);
            this.level.addFreshEntity((Entity)item);
        }
        if (!this.secondaryCoil.isEmpty()) {
            item = new ItemEntity(this.level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), this.secondaryCoil);
            this.level.addFreshEntity((Entity)item);
        }
    }

    @Override
    public int getPowerUsage() {
        IElectric be;
        Direction facing = this.getDirection();
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId() && be.hasElectricitySlot(facing.getOpposite())) {
            return Math.max(be.getNetworkPowerUsage(this), 0);
        }
        return 0;
    }

    public void updateCoils() {
        if (this.primaryCoil.get(TFMGDataComponents.COIL_TURNS) == null || this.secondaryCoil.get(TFMGDataComponents.COIL_TURNS) == null) {
            return;
        }
        int primaryTurns = (Integer)this.primaryCoil.get(TFMGDataComponents.COIL_TURNS);
        int secondaryTurns = (Integer)this.secondaryCoil.get(TFMGDataComponents.COIL_TURNS);
        if (this.primaryCoil.isEmpty() || this.secondaryCoil.isEmpty() || primaryTurns < 50 || secondaryTurns < 50) {
            this.coilRatio = 0.0f;
            this.updateNextTick();
            this.updateInFront();
            return;
        }
        this.coilRatio = (float)secondaryTurns / (float)primaryTurns;
        this.updateNextTick();
        this.updateInFront();
    }

    @Override
    public boolean makeMultimeterTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.makeMultimeterTooltip(tooltip, isPlayerSneaking);
        if (this.coilRatio != 0.0f) {
            CreateLang.text((String)"----------------------------").style(ChatFormatting.WHITE).forGoggles(tooltip);
            CreateLang.translate((String)"multimeter.transformer_ratio", (Object[])new Object[0]).add(CreateLang.number((double)this.coilRatio)).color(13035564).forGoggles(tooltip, 1);
        }
        return true;
    }

    @Override
    public float resistance() {
        IElectric be;
        Direction facing = ((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getCounterClockWise();
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId() && be.hasElectricitySlot(facing.getOpposite())) {
            return Math.max(be.getNetworkResistance(), 0);
        }
        return 0.0f;
    }

    public Direction getDirection() {
        if (!this.getBlockState().hasProperty((Property)DirectionalBlock.FACING)) {
            return ((Direction)this.getBlockState().getValue((Property)TFMGHorizontalDirectionalBlock.FACING)).getCounterClockWise();
        }
        return (Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING);
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getClockWise();
    }

    @Override
    public void onNetworkChanged(int oldVoltage, int oldPower) {
        super.onNetworkChanged(oldVoltage, oldPower);
        if (oldVoltage != this.getData().getVoltage() || oldPower != this.getPowerUsage()) {
            this.updateInFront = true;
        }
        this.sendStuff();
        this.setChanged();
    }

    @Override
    public void updateNetwork() {
        super.updateNetwork();
        this.updateInFront();
    }

    @Override
    public void remove() {
        super.remove();
        this.updateInFront();
    }

    @Override
    public void onPlaced() {
        super.onPlaced();
        this.updateInFront = true;
    }

    public void updateInFront() {
        IElectric be;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CatnipServices.NETWORK.sendToClientsTrackingChunk(serverLevel, new ChunkPos(this.worldPosition), (CustomPacketPayload)new UpdateInFrontPacket(BlockPos.of((long)this.getPos())));
        }
        Direction facing = this.getBlockState().hasProperty((Property)DirectionalBlock.FACING) ? (Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING) : ((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getCounterClockWise();
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId() && be.hasElectricitySlot(facing.getOpposite())) {
            be.updateNextTick();
        }
        this.sendStuff();
        this.setChanged();
    }

    @Override
    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        if (!this.primaryCoil.isEmpty()) {
            compound.put("PrimaryCoil", this.primaryCoil.saveOptional(registries));
        }
        if (!this.secondaryCoil.isEmpty()) {
            compound.put("SecondaryCoil", this.secondaryCoil.save(registries));
        }
        compound.putFloat("CoilRation", this.coilRatio);
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        if (compound.contains("PrimaryCoil")) {
            ItemStack.parse((HolderLookup.Provider)registries, (Tag)compound.getCompound("PrimaryCoil")).ifPresent(i -> {
                this.primaryCoil = i;
            });
        }
        if (compound.contains("SecondaryCoil")) {
            ItemStack.parse((HolderLookup.Provider)registries, (Tag)compound.getCompound("SecondaryCoil")).ifPresent(i -> {
                this.secondaryCoil = i;
            });
        }
        this.coilRatio = compound.getFloat("CoilRation");
    }
}

