/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines;

import com.drmangotea.tfmg.registry.TFMGDataComponents;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidContainingItem
extends Item {
    public final FluidEntry<?> fluid;
    public static final int CAPACITY = 4000;

    public FluidContainingItem(Item.Properties p_41383_, FluidEntry<?> fluid) {
        super(p_41383_);
        this.fluid = fluid;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)CreateLang.translateDirect((String)"tooltip.fluid_item", (Object[])new Object[]{stack.get(TFMGDataComponents.AMOUNT) == null ? Integer.valueOf(0) : stack.get(TFMGDataComponents.AMOUNT)}).withStyle(ChatFormatting.GREEN));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity blockEntity;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        if (context.getPlayer().isShiftKeyDown() && (Integer)stack.get(TFMGDataComponents.AMOUNT) > 0) {
            level.playSound(null, pos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            stack.set(TFMGDataComponents.AMOUNT, (Object)0);
            return InteractionResult.SUCCESS;
        }
        if (level.getBlockEntity(pos) != null && (blockEntity = level.getBlockEntity(pos)) instanceof FluidTankBlockEntity) {
            FluidTankBlockEntity be;
            FluidTankBlockEntity fluidTankBe = (FluidTankBlockEntity)blockEntity;
            FluidTankBlockEntity fluidTankBlockEntity = be = fluidTankBe.isController() ? fluidTankBe : fluidTankBe.getControllerBE();
            if (be.getFluid(0).getFluid().isSame((Fluid)this.fluid.get())) {
                int toDrain = Math.min(4000 - (Integer)stack.get(TFMGDataComponents.AMOUNT), be.getFluid(0).getAmount());
                if (toDrain == 0 || context.getPlayer().getCooldowns().isOnCooldown(stack.getItem())) {
                    return InteractionResult.PASS;
                }
                level.playSound(null, be.getBlockPos(), SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                be.getTankInventory().drain(toDrain, IFluidHandler.FluidAction.EXECUTE);
                stack.set(TFMGDataComponents.AMOUNT, (Object)((Integer)stack.get(TFMGDataComponents.AMOUNT) + toDrain));
                context.getPlayer().getCooldowns().addCooldown(stack.getItem(), 20);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

