/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.engine_controller;

import com.drmangotea.tfmg.content.engines.engine_controller.EngineControllerMenu;
import com.drmangotea.tfmg.registry.TFMGGuiTextures;
import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.utility.ControlsUtil;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EngineControllerScreen
extends AbstractSimiContainerScreen<EngineControllerMenu> {
    protected TFMGGuiTextures background;
    private List<Rect2i> extraAreas = Collections.emptyList();
    private IconButton resetButton;
    private IconButton confirmButton;

    public EngineControllerScreen(EngineControllerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.background = TFMGGuiTextures.ENGINE_CONTROLLER;
    }

    protected void init() {
        this.setWindowSize(this.background.width, this.background.height + 4 + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        this.setWindowOffset(50, 0);
        super.init();
        int x = this.leftPos;
        int y = this.topPos;
        this.resetButton = new IconButton(x + this.background.width - 170, y + this.background.height - 24, (ScreenElement)AllIcons.I_TRASH);
        this.resetButton.withCallback(() -> {
            ((EngineControllerMenu)this.menu).clearContents();
            ((EngineControllerMenu)this.menu).sendClearPacket();
        });
        this.confirmButton = new IconButton(x + this.background.width - 117, y + this.background.height - 24, (ScreenElement)AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.minecraft.player.closeContainer());
        this.addRenderableWidget((GuiEventListener)this.resetButton);
        this.addRenderableWidget((GuiEventListener)this.confirmButton);
        this.extraAreas = ImmutableList.of((Object)new Rect2i(x + this.background.width + 4, y + this.background.height - 44, 64, 56));
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.getWidth());
        int invY = this.topPos + this.background.height + 4;
        this.renderPlayerInventory(graphics, invX, invY);
        int x = this.leftPos;
        int y = this.topPos;
        this.background.render(graphics, x, y);
        graphics.drawString(this.font, this.title, x + 15, y + 4, 5841956, false);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((BlockEntity)((BlockEntity)((EngineControllerMenu)this.menu).contentHolder)).at((float)(x + this.background.width - 4), (float)(y + this.background.height - 56), -200.0f)).scale(5.0).render(graphics);
    }

    protected void containerTick() {
        super.containerTick();
    }

    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        if (!((EngineControllerMenu)this.menu).getCarried().isEmpty() || this.hoveredSlot == null || this.hoveredSlot.container == ((EngineControllerMenu)this.menu).playerInventory) {
            super.renderTooltip(graphics, x, y);
            return;
        }
        List<Object> list = new LinkedList<Component>();
        if (this.hoveredSlot.hasItem()) {
            list = this.getTooltipFromContainerItem(this.hoveredSlot.getItem());
        }
        graphics.renderComponentTooltip(this.font, this.addToTooltip(list, this.hoveredSlot.getSlotIndex()), x, y);
    }

    private List<Component> addToTooltip(List<Component> list, int slot) {
        if (slot < 0 || slot >= 12) {
            return list;
        }
        list.add((Component)CreateLang.translateDirect((String)("engine_controller0.frequency_slot_" + (slot % 2 + 1)), (Object[])new Object[]{((KeyMapping)ControlsUtil.getControls().get(slot / 2)).getTranslatedKeyMessage().getString()}).withStyle(ChatFormatting.GOLD));
        return list;
    }

    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

