/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.types.large_engine;

import com.drmangotea.tfmg.base.TFMGShapes;
import com.drmangotea.tfmg.content.engines.types.large_engine.LargeEngineBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.content.kinetics.steamEngine.PoweredShaftBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LargeEngineBlock
extends HorizontalDirectionalBlock
implements IWrenchable,
IBE<LargeEngineBlockEntity> {
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.ATTACH_FACE;
    public static final MapCodec<LargeEngineBlock> CODEC = LargeEngineBlock.simpleCodec(LargeEngineBlock::new);
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public LargeEngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACE, (Comparable)AttachFace.FLOOR)).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public static Direction getConnectedDirection(BlockState p_53201_) {
        switch ((AttachFace)p_53201_.getValue(FACE)) {
            case CEILING: {
                return Direction.DOWN;
            }
            case FLOOR: {
                return Direction.UP;
            }
        }
        return (Direction)p_53201_.getValue((Property)FACING);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{FACE, FACING, BlockStateProperties.WATERLOGGED}));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_53184_) {
        for (Direction direction : p_53184_.getNearestLookingDirections()) {
            BlockState blockstate = direction.getAxis() == Direction.Axis.Y ? (BlockState)((BlockState)this.defaultBlockState().setValue(FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).setValue((Property)FACING, (Comparable)p_53184_.getHorizontalDirection()) : (BlockState)((BlockState)this.defaultBlockState().setValue(FACE, (Comparable)AttachFace.WALL)).setValue((Property)FACING, (Comparable)direction.getOpposite());
            if (!blockstate.canSurvive((LevelReader)p_53184_.getLevel(), p_53184_.getClickedPos())) continue;
            return blockstate;
        }
        return null;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        ItemStack heldItem = player.getItemInHand(hand);
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (placementHelper.matchesItem(heldItem)) {
            return placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.getItem(), player, hand, ray);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor world, BlockPos pos, BlockPos neighbourPos) {
        return state;
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        BlockPos shaftPos = LargeEngineBlock.getShaftPos(pState, pPos);
        BlockState shaftState = pLevel.getBlockState(shaftPos);
        if (LargeEngineBlock.isShaftValid(pState, shaftState)) {
            pLevel.setBlock(shaftPos, PoweredShaftBlock.getEquivalent((BlockState)shaftState), 3);
        }
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!(!pState.hasBlockEntity() || pState.is(pNewState.getBlock()) && pNewState.hasBlockEntity())) {
            pLevel.removeBlockEntity(pPos);
        }
        FluidTankBlock.updateBoilerState((BlockState)pState, (Level)pLevel, (BlockPos)pPos.relative(LargeEngineBlock.getFacing(pState).getOpposite()));
        BlockPos shaftPos = LargeEngineBlock.getShaftPos(pState, pPos);
        BlockState shaftState = pLevel.getBlockState(shaftPos);
        if (AllBlocks.POWERED_SHAFT.has(shaftState)) {
            pLevel.scheduleTick(shaftPos, shaftState.getBlock(), 1);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (TFMGBlocks.LARGE_ENGINE.has(state)) {
            return TFMGShapes.FULL;
        }
        AttachFace face = (AttachFace)state.getValue(FACE);
        Direction direction = (Direction)state.getValue((Property)FACING);
        return face == AttachFace.CEILING ? AllShapes.STEAM_ENGINE_CEILING.get(direction.getAxis()) : (face == AttachFace.FLOOR ? AllShapes.STEAM_ENGINE.get(direction.getAxis()) : AllShapes.STEAM_ENGINE_WALL.get(direction));
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public static Direction getFacing(BlockState sideState) {
        return LargeEngineBlock.getConnectedDirection(sideState);
    }

    public static BlockPos getShaftPos(BlockState sideState, BlockPos pos) {
        return pos.relative(LargeEngineBlock.getConnectedDirection(sideState), 2);
    }

    public static boolean isShaftValid(BlockState state, BlockState shaft) {
        return (AllBlocks.SHAFT.has(shaft) || AllBlocks.POWERED_SHAFT.has(shaft)) && shaft.getValue((Property)ShaftBlock.AXIS) != LargeEngineBlock.getFacing(state).getAxis();
    }

    public Class<LargeEngineBlockEntity> getBlockEntityClass() {
        return LargeEngineBlockEntity.class;
    }

    public BlockEntityType<? extends LargeEngineBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.LARGE_ENGINE.get();
    }

    public static Couple<Integer> getSpeedRange() {
        return Couple.create((Object)16, (Object)128);
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> ((BlockEntry)AllBlocks.SHAFT).isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return s -> s.getBlock() instanceof LargeEngineBlock;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction direction;
            BlockPos shaftPos = LargeEngineBlock.getShaftPos(state, pos);
            BlockState shaft = AllBlocks.SHAFT.getDefaultState();
            Direction[] directionArray = Direction.orderedByNearest((Entity)player);
            int n = directionArray.length;
            for (int i = 0; i < n && !LargeEngineBlock.isShaftValid(state, shaft = (BlockState)shaft.setValue((Property)ShaftBlock.AXIS, (Comparable)(direction = directionArray[i]).getAxis())); ++i) {
            }
            BlockState newState = world.getBlockState(shaftPos);
            if (!newState.canBeReplaced()) {
                return PlacementOffset.fail();
            }
            Direction.Axis axis = (Direction.Axis)shaft.getValue((Property)ShaftBlock.AXIS);
            return PlacementOffset.success((Vec3i)shaftPos, s -> (BlockState)BlockHelper.copyProperties((BlockState)s, (BlockState)AllBlocks.POWERED_SHAFT.getDefaultState()).setValue((Property)PoweredShaftBlock.AXIS, (Comparable)axis));
        }
    }
}

