/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.types.regular_engine;

import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.engines.base.EngineBlock;
import com.drmangotea.tfmg.content.engines.types.AbstractSmallEngineBlockEntity;
import com.drmangotea.tfmg.content.engines.types.regular_engine.RegularEngineBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class RegularEngineBlock
extends EngineBlock
implements IBE<RegularEngineBlockEntity> {
    public static final BooleanProperty EXTENDED = BooleanProperty.create((String)"extended");

    public RegularEngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{EXTENDED});
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        RegularEngineBlockEntity be;
        ItemStack itemStack = player.getItemInHand(hand);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RegularEngineBlockEntity && !(be = (RegularEngineBlockEntity)blockEntity).isController() && (blockEntity = level.getBlockEntity(be.controller)) instanceof AbstractSmallEngineBlockEntity) {
            AbstractSmallEngineBlockEntity controller = (AbstractSmallEngineBlockEntity)blockEntity;
            if (controller.nextComponent().test(itemStack) && controller.componentsInventory.insertItem(itemStack)) {
                if (!itemStack.is((Item)TFMGItems.SCREWDRIVER.get())) {
                    itemStack.shrink(1);
                }
                controller.playInsertionSound();
                controller.updateRotation();
                controller.setChanged();
                controller.sendData();
                return ItemInteractionResult.SUCCESS;
            }
            if (controller instanceof RegularEngineBlockEntity) {
                RegularEngineBlockEntity be1 = (RegularEngineBlockEntity)controller;
                if (!be1.pistonInventory.isEmpty() && !((RegularEngineBlockEntity)controller).pistonInventory.isEmpty()) {
                    return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
                }
            }
            if (itemStack.is((Item)TFMGItems.SCREWDRIVER.get()) && be.pistonInventory.isEmpty()) {
                for (int i = controller.componentsInventory.components.size() - 1; i >= 0; --i) {
                    if (controller.componentsInventory.getItem(i).isEmpty()) continue;
                    controller.dropItem(controller.componentsInventory.getItem(i));
                    controller.componentsInventory.setStackInSlot(i, ItemStack.EMPTY);
                    controller.playRemovalSound();
                    controller.updateRotation();
                    controller.setChanged();
                    controller.sendData();
                    return ItemInteractionResult.SUCCESS;
                }
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public void onPlace(BlockState pState, Level level, BlockPos pos, BlockState pOldState, boolean pIsMoving) {
        this.withBlockEntityDo((BlockGetter)level, pos, IElectric::onPlaced);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public Class<RegularEngineBlockEntity> getBlockEntityClass() {
        return RegularEngineBlockEntity.class;
    }

    public BlockEntityType<? extends RegularEngineBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.REGULAR_ENGINE.get();
    }
}

