/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.misc.air_intake;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.content.machinery.misc.air_intake.AirIntakeBlock;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class AirIntakeBlockEntity
extends KineticBlockEntity
implements IWrenchable {
    int diameter = 1;
    boolean isController = false;
    public boolean hasShaft = true;
    boolean isUsedByController = false;
    public BlockPos controller;
    public List<AirIntakeBlockEntity> blockEntities = new ArrayList<AirIntakeBlockEntity>();
    public float maxShaftSpeed = 0.0f;
    public float angle = 0.0f;
    public LerpedFloat visual_angle = LerpedFloat.angular();
    protected FluidTank tankInventory = this.createInventory();
    protected IFluidHandler fluidCapability = this.tankInventory;

    public AirIntakeBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.AIR_INTAKE.get(), (be, context) -> be.fluidCapability);
    }

    public void tick() {
        super.tick();
        int production = (int)this.maxShaftSpeed * (this.diameter * this.diameter) / 40;
        if (this.tankInventory.getFluidAmount() + production <= this.tankInventory.getCapacity()) {
            this.tankInventory.setFluid(new FluidStack(FluidHelper.convertToStill((Fluid)((Fluid)TFMGFluids.AIR.get())), production + this.tankInventory.getFluidAmount()));
        }
        if (this.isUsedByController) {
            this.refreshCapability();
            this.sendData();
            this.setChanged();
        }
        if (this.diameter == 3) {
            this.visual_angle.chase((double)this.angle, (double)0.1f, LerpedFloat.Chaser.EXP);
            this.visual_angle.tickChaser();
        }
        this.angle += this.maxShaftSpeed / 2.0f;
        this.angle %= 360.0f;
        if (this.isUsedByController) {
            this.blockEntities.clear();
        }
        if (!((Boolean)this.getBlockState().getValue((Property)AirIntakeBlock.INVISIBLE)).booleanValue() && (this.isController || this.isUsedByController)) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)AirIntakeBlock.INVISIBLE, (Comparable)Boolean.valueOf(true)), 2);
        }
        if (!this.isController && !this.isUsedByController) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)AirIntakeBlock.INVISIBLE, (Comparable)Boolean.valueOf(false)), 2);
        }
        if (this.controller == null) {
            this.controller = this.getBlockPos();
        }
        this.diameter = this.getPossibleDiameter();
        if (this.controller == this.getBlockPos()) {
            this.isUsedByController = false;
        } else {
            this.isUsedByController = true;
            this.isController = false;
        }
        if (this.diameter == 1) {
            this.isController = false;
        }
        if (!(this.level.getBlockEntity(this.controller) instanceof AirIntakeBlockEntity)) {
            this.isUsedByController = false;
            this.controller = this.getBlockPos();
        } else if (!((AirIntakeBlockEntity)this.level.getBlockEntity((BlockPos)this.controller)).isController) {
            this.isUsedByController = false;
        }
        if (this.controller != null) {
            if (this.level.getBlockEntity(this.controller) != null && ((AirIntakeBlockEntity)this.level.getBlockEntity((BlockPos)this.controller)).diameter == 2) {
                int x = Math.abs(this.getBlockPos().getX() - this.controller.getX());
                int y = Math.abs(this.getBlockPos().getY() - this.controller.getY());
                int z = Math.abs(this.getBlockPos().getZ() - this.controller.getZ());
                int distanceFromController = x + y + z;
                if (x > 1 || y > 1 || z > 1) {
                    this.isUsedByController = false;
                    this.controller = this.getBlockPos();
                }
            }
            if (this.level.getBlockEntity(this.controller) != null && ((AirIntakeBlockEntity)this.level.getBlockEntity((BlockPos)this.controller)).diameter == 1) {
                this.isUsedByController = false;
                this.controller = this.getBlockPos();
            }
        }
        if (this.diameter == 1) {
            this.maxShaftSpeed = Math.abs(this.getSpeed());
        } else {
            this.maxShaftSpeed = Math.abs(this.getSpeed());
            ArrayList<Float> speeds = new ArrayList<Float>();
            for (AirIntakeBlockEntity be : this.blockEntities) {
                speeds.add(Float.valueOf(Math.abs(be.getSpeed())));
            }
            Iterator<AirIntakeBlockEntity> iterator = speeds.iterator();
            while (iterator.hasNext()) {
                float testedSpeed = ((Float)((Object)iterator.next())).floatValue();
                if (!(testedSpeed > this.maxShaftSpeed)) continue;
                this.maxShaftSpeed = testedSpeed;
            }
        }
        if (this.isUsedByController) {
            return;
        }
        if (this.diameter == 2 && this.blockEntities.toArray().length != 4) {
            return;
        }
        if (this.diameter == 3 && this.blockEntities.toArray().length != 9) {
            return;
        }
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateCapabilities();
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Direction direction = context.getClickedFace();
        if (direction == ((Direction)this.getBlockState().getValue((Property)DirectionalKineticBlock.FACING)).getOpposite()) {
            this.hasShaft = !this.hasShaft;
        }
        return InteractionResult.SUCCESS;
    }

    public void setController(BlockPos controllerPos) {
        this.controller = controllerPos;
    }

    private void refreshCapability() {
        FluidTank handlerForCapability = this.controller == null || this.controller == this.getBlockPos() ? this.tankInventory : ((AirIntakeBlockEntity)this.level.getBlockEntity(this.controller) != null ? ((AirIntakeBlockEntity)this.level.getBlockEntity((BlockPos)this.controller)).tankInventory : this.tankInventory);
        FluidTank finalHandlerForCapability = handlerForCapability;
        this.fluidCapability = finalHandlerForCapability;
    }

    public int getPossibleDiameter() {
        AirIntakeBlockEntity checkedBE;
        if (this.controller != this.getBlockPos()) {
            return 1;
        }
        BlockPos checkedPos = this.getBlockPos();
        Direction direction = (Direction)this.getBlockState().getValue((Property)DirectionalKineticBlock.FACING);
        ArrayList<BlockPos> checkedPosses = new ArrayList<BlockPos>();
        checkedPos = this.getBlockPos();
        boolean canBeMedium = true;
        for (int x = 0; x < 2; ++x) {
            for (int z = 0; z < 2; ++z) {
                checkedPosses.add(checkedPos);
                checkedPos = direction.getAxis().isHorizontal() ? checkedPos.above() : checkedPos.east();
            }
            if (direction.getAxis().isHorizontal()) {
                checkedPos = checkedPos.below(2);
                checkedPos = checkedPos.relative(direction.getClockWise());
                continue;
            }
            checkedPos = checkedPos.west(2);
            checkedPos = checkedPos.south();
        }
        ArrayList<BlockPos> checkedPossesLarge = new ArrayList<BlockPos>();
        checkedPos = this.getBlockPos();
        boolean canBeLarge = true;
        for (int x = 0; x < 3; ++x) {
            for (int z = 0; z < 3; ++z) {
                checkedPossesLarge.add(checkedPos);
                checkedPos = direction.getAxis().isHorizontal() ? checkedPos.above() : checkedPos.east();
            }
            if (direction.getAxis().isHorizontal()) {
                checkedPos = checkedPos.below(3);
                checkedPos = checkedPos.relative(direction.getClockWise());
                continue;
            }
            checkedPos = checkedPos.west(3);
            checkedPos = checkedPos.south();
        }
        for (BlockPos pos : checkedPossesLarge) {
            if (!(this.level.getBlockEntity(pos) instanceof AirIntakeBlockEntity)) {
                canBeLarge = false;
                break;
            }
            checkedBE = (AirIntakeBlockEntity)this.level.getBlockEntity(pos);
            if (checkedBE.getBlockState().getValue((Property)DirectionalKineticBlock.FACING) == this.getBlockState().getValue((Property)DirectionalKineticBlock.FACING)) continue;
            canBeLarge = false;
            break;
        }
        for (BlockPos pos : checkedPosses) {
            if (!(this.level.getBlockEntity(pos) instanceof AirIntakeBlockEntity)) {
                canBeMedium = false;
                break;
            }
            checkedBE = (AirIntakeBlockEntity)this.level.getBlockEntity(pos);
            if (pos != this.getBlockPos() && checkedBE.isController) {
                canBeMedium = false;
                break;
            }
            if (checkedBE.getBlockState().getValue((Property)DirectionalKineticBlock.FACING) == this.getBlockState().getValue((Property)DirectionalKineticBlock.FACING)) continue;
            canBeMedium = false;
            break;
        }
        if (canBeLarge) {
            this.blockEntities.clear();
            for (BlockPos pos : checkedPossesLarge) {
                if (((AirIntakeBlockEntity)this.level.getBlockEntity((BlockPos)pos)).isUsedByController && ((AirIntakeBlockEntity)this.level.getBlockEntity((BlockPos)pos)).controller != this.getBlockPos() && pos != this.getBlockPos() || this.isController) {
                    ((AirIntakeBlockEntity)this.level.getBlockEntity((BlockPos)pos)).isUsedByController = true;
                    ((AirIntakeBlockEntity)this.level.getBlockEntity((BlockPos)pos)).isController = false;
                    ((AirIntakeBlockEntity)this.level.getBlockEntity((BlockPos)pos)).controller = this.getBlockPos();
                }
                ((AirIntakeBlockEntity)this.level.getBlockEntity(pos)).setController(this.getBlockPos());
                this.blockEntities.add((AirIntakeBlockEntity)this.level.getBlockEntity(pos));
            }
            this.controller = this.getBlockPos();
            this.isController = true;
            return 3;
        }
        if (canBeMedium) {
            this.blockEntities.clear();
            for (BlockPos pos : checkedPosses) {
                if (((AirIntakeBlockEntity)this.level.getBlockEntity((BlockPos)pos)).isUsedByController && ((AirIntakeBlockEntity)this.level.getBlockEntity((BlockPos)pos)).controller != this.getBlockPos() && pos != this.getBlockPos()) {
                    this.controller = this.getBlockPos();
                    this.isController = false;
                    return 1;
                }
                ((AirIntakeBlockEntity)this.level.getBlockEntity(pos)).setController(this.getBlockPos());
                this.blockEntities.add((AirIntakeBlockEntity)this.level.getBlockEntity(pos));
            }
            this.controller = this.getBlockPos();
            this.isController = true;
            return 2;
        }
        this.controller = this.getBlockPos();
        this.isController = false;
        return 1;
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.getBlockPos()).inflate(3.0);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        TFMGUtils.createFluidTooltip((BlockEntity)this, tooltip);
        return true;
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(this, 8000, this::onFluidStackChanged){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().isSame((Fluid)TFMGFluids.AIR.getSource());
            }
        };
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        this.setChanged();
        this.sendData();
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.diameter = compound.getInt("Diameter");
        this.isController = compound.getBoolean("IsController");
        this.isUsedByController = compound.getBoolean("IsUsed");
        this.hasShaft = compound.getBoolean("HasShaft");
        this.tankInventory.readFromNBT(registries, compound.getCompound("TankContent"));
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putInt("Diameter", this.diameter);
        compound.putBoolean("IsController", this.isController);
        compound.putBoolean("IsUsed", this.isUsedByController);
        compound.putBoolean("HasShaft", this.hasShaft);
        compound.put("TankContent", (Tag)this.tankInventory.writeToNBT(registries, new CompoundTag()));
    }
}

