/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.misc.winding_machine;

import com.drmangotea.tfmg.content.machinery.misc.winding_machine.SpoolItem;
import com.drmangotea.tfmg.content.machinery.misc.winding_machine.WindingMachineBlock;
import com.drmangotea.tfmg.recipes.WindingRecipe;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGDataComponents;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public class WindingMachineBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    LerpedFloat spoolSpeed = LerpedFloat.linear();
    float angle;
    public SmartInventory inventory;
    public IItemHandlerModifiable itemCapability;
    public ItemStack spool = ItemStack.EMPTY;
    public WindingRecipe recipe;
    public int amountWinded = 0;
    public boolean update = false;
    protected ScrollValueBehaviour turnPercentage;

    public WindingMachineBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.setLazyTickRate(10);
        this.inventory = new SmartInventory(1, (SyncedBlockEntity)this).withMaxStackSize(1).whenContentsChanged(i -> this.onContentsChanged());
        this.itemCapability = this.inventory;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.WINDING_MACHINE.get(), (be, context) -> be.itemCapability);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        int max = 100;
        this.turnPercentage = new ScrollValueBehaviour((Component)CreateLang.translateDirect((String)"winding_machine.turn_percentage", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new WindingMachineValueBox());
        this.turnPercentage.between(1, max);
        this.turnPercentage.value = 20;
        behaviours.add((BlockEntityBehaviour)this.turnPercentage);
    }

    public void onContentsChanged() {
        this.findRecipe();
        if (this.inventory.isEmpty()) {
            this.amountWinded = 0;
        }
    }

    public void findRecipe() {
        Optional optional = TFMGRecipeTypes.WINDING.find(new RecipeWrapper((IItemHandler)this.inventory), this.level);
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.level, (RecipeInput)new RecipeWrapper((IItemHandler)this.inventory), TFMGRecipeTypes.WINDING.getType(), WindingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            this.recipe = (WindingRecipe)((RecipeHolder)assemblyRecipe.get()).value();
            return;
        }
        if (optional.isEmpty()) {
            this.recipe = null;
            return;
        }
        WindingRecipe windingRecipe = (WindingRecipe)optional.get().value();
        if (windingRecipe.getIngredient().test(this.inventory.getItem(0))) {
            this.recipe = windingRecipe;
        }
    }

    public void lazyTick() {
        super.lazyTick();
        this.onContentsChanged();
        if (this.spool.is((Item)TFMGItems.EMPTY_SPOOL.get()) && !((Boolean)this.getBlockState().getValue((Property)WindingMachineBlock.POWERED)).booleanValue()) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)WindingMachineBlock.POWERED, (Comparable)Boolean.valueOf(true)), 2);
            this.update = true;
        }
        if (!this.spool.is((Item)TFMGItems.EMPTY_SPOOL.get()) && ((Boolean)this.getBlockState().getValue((Property)WindingMachineBlock.POWERED)).booleanValue()) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)WindingMachineBlock.POWERED, (Comparable)Boolean.valueOf(false)), 2);
            this.update = true;
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"goggles.winding_machine.header", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        if (!this.spool.isEmpty()) {
            CreateLang.text((String)this.spool.getDisplayName().getString().replace("[", "").replace("]", "")).color(this.spool.getBarColor()).forGoggles(tooltip);
            if (this.spool.get(TFMGDataComponents.SPOOL_AMOUNT) != null) {
                CreateLang.translate((String)"goggles.winding_machine.turns", (Object[])new Object[0]).add(CreateLang.number((double)((Integer)this.spool.get(TFMGDataComponents.SPOOL_AMOUNT)).intValue())).color(this.spool.getBarColor()).forGoggles(tooltip);
            }
            if (this.recipe != null) {
                CreateLang.text((String)"").add(CreateLang.translate((String)"goggles.winding_machine.progress", (Object[])new Object[0])).add(CreateLang.number((double)this.amountWinded)).add(Component.literal((String)("/" + this.recipe.getProcessingDuration()))).color(this.spool.getBarColor()).forGoggles(tooltip);
            }
        }
        return true;
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.inventory);
        Containers.dropItemStack((Level)this.getLevel(), (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (ItemStack)this.spool);
    }

    public void tick() {
        super.tick();
        this.performRecipe();
        if (this.update) {
            this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
            this.update = false;
        }
        if (this.level.isClientSide) {
            this.manageRotation();
        }
    }

    public void performRecipe() {
        int defaultResistance = 0;
        int defaultSpoolAmount = 0;
        int defaultCoilTurns = 0;
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.inventory.getItem(0).is((Item)TFMGItems.ELECTROMAGNETIC_COIL.get()) && this.spool.is((Item)TFMGItems.COPPER_SPOOL.get()) && (Integer)this.spool.getOrDefault(TFMGDataComponents.SPOOL_AMOUNT, (Object)defaultSpoolAmount) > 0 && (Integer)this.inventory.getItem(0).getOrDefault(TFMGDataComponents.COIL_TURNS, (Object)defaultCoilTurns) < this.turnPercentage.getValue() * 10 && (Integer)this.inventory.getItem(0).getOrDefault(TFMGDataComponents.COIL_TURNS, (Object)defaultCoilTurns) < this.turnPercentage.getValue() * 10) {
            this.spool.set(TFMGDataComponents.SPOOL_AMOUNT, (Object)((Integer)this.spool.getOrDefault(TFMGDataComponents.SPOOL_AMOUNT, (Object)defaultSpoolAmount) - 1));
            this.inventory.getItem(0).set(TFMGDataComponents.COIL_TURNS, (Object)((Integer)this.inventory.getItem(0).getOrDefault(TFMGDataComponents.COIL_TURNS, (Object)defaultCoilTurns) + 1));
            return;
        }
        if (this.spool.has(TFMGDataComponents.SPOOL_AMOUNT) && this.inventory.getItem(0).is(TFMGBlocks.RESISTOR.asItem()) && this.spool.is((Item)TFMGItems.CONSTANTAN_SPOOL.get()) && (Integer)this.spool.getOrDefault(TFMGDataComponents.SPOOL_AMOUNT, (Object)defaultSpoolAmount) > 0 && (Integer)this.inventory.getItem(0).getOrDefault(TFMGDataComponents.RESISTANCE, (Object)defaultResistance) < this.turnPercentage.getValue() * 10 && (Integer)this.inventory.getItem(0).getOrDefault(TFMGDataComponents.RESISTANCE, (Object)0) < this.turnPercentage.getValue() * 10) {
            this.spool.set(TFMGDataComponents.SPOOL_AMOUNT, (Object)((Integer)this.spool.getOrDefault(TFMGDataComponents.SPOOL_AMOUNT, (Object)defaultSpoolAmount) - 1));
            this.inventory.getItem(0).set(TFMGDataComponents.RESISTANCE, (Object)((Integer)this.inventory.getItem(0).getOrDefault(TFMGDataComponents.RESISTANCE, (Object)defaultResistance) + 1));
            return;
        }
        if (this.spool.has(TFMGDataComponents.SPOOL_AMOUNT) && (Integer)this.spool.getOrDefault(TFMGDataComponents.SPOOL_AMOUNT, (Object)defaultSpoolAmount) == 0 && !this.spool.is((Item)TFMGItems.EMPTY_SPOOL.get()) && this.spool.getItem() instanceof SpoolItem) {
            this.spool = TFMGItems.EMPTY_SPOOL.asStack();
        }
        if (this.recipe == null) {
            return;
        }
        if (this.amountWinded >= this.recipe.getProcessingDuration()) {
            this.inventory.setStackInSlot(0, (ItemStack)this.recipe.rollResults().get(0));
            this.recipe = null;
            this.amountWinded = 0;
            this.sendData();
            this.setChanged();
        } else {
            if (this.spool.isEmpty() || this.spool.is((Item)TFMGItems.EMPTY_SPOOL.get())) {
                return;
            }
            if ((Integer)this.spool.get(TFMGDataComponents.SPOOL_AMOUNT) > 0) {
                if (this.recipe.getSpool().test(this.spool)) {
                    this.spool.set(TFMGDataComponents.SPOOL_AMOUNT, (Object)((Integer)this.spool.get(TFMGDataComponents.SPOOL_AMOUNT) - 1));
                    ++this.amountWinded;
                }
            } else {
                this.inventory.setStackInSlot(0, (ItemStack)this.recipe.rollResults().get(0));
                this.sendData();
                this.setChanged();
            }
        }
    }

    public void manageRotation() {
        float targetSpeed = (float)Math.min(Math.abs((double)this.getSpeed() * 1.5), 30.0);
        this.spoolSpeed.updateChaseTarget(targetSpeed);
        this.spoolSpeed.tickChaser();
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        compound.put("Spool", this.spool.saveOptional(registries));
        compound.putInt("AmountWinded", this.amountWinded);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
        if (compound.contains("Spool")) {
            ItemStack.parse((HolderLookup.Provider)registries, (Tag)compound.getCompound("Spool")).ifPresent(i -> {
                this.spool = i;
            });
        }
        this.amountWinded = compound.getInt("AmountWinded");
        if (clientPacket) {
            this.spoolSpeed.chase((double)this.getGeneratedSpeed(), 0.0625, LerpedFloat.Chaser.EXP);
        }
    }

    public static class WindingMachineValueBox
    extends ValueBoxTransform.Sided {
        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)4.0, (double)16.05);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction == state.getValue(HorizontalKineticBlock.HORIZONTAL_FACING);
        }
    }
}

