/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.vat.industrial_mixer;

import com.drmangotea.tfmg.content.machinery.vat.base.VatBlock;
import com.drmangotea.tfmg.content.machinery.vat.industrial_mixer.IndustrialMixerBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class IndustrialMixerBlock
extends KineticBlock
implements IBE<IndustrialMixerBlockEntity> {
    public IndustrialMixerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == Direction.UP;
    }

    public void onRemove(BlockState state, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        VatBlock.updateVatState(state, pLevel, pPos.relative(Direction.DOWN));
        super.onRemove(state, pLevel, pPos, pNewState, pIsMoving);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (hand == InteractionHand.OFF_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IndustrialMixerBlockEntity) {
            IndustrialMixerBlockEntity be = (IndustrialMixerBlockEntity)blockEntity;
            IndustrialMixerBlockEntity.MixerMode mixerMode = be.mixerMode;
            ItemStack stackInside = mixerMode.item;
            if (stack.is(stackInside.getItem())) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (be.setMixerMode(stack, true)) {
                player.setItemInHand(hand, mixerMode.item);
                be.setMixerMode(stack, false);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onPlace(BlockState state, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        VatBlock.updateVatState(state, pLevel, pPos.relative(Direction.DOWN));
        super.onPlace(state, pLevel, pPos, pOldState, pIsMoving);
    }

    public Class<IndustrialMixerBlockEntity> getBlockEntityClass() {
        return IndustrialMixerBlockEntity.class;
    }

    public BlockEntityType<? extends IndustrialMixerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.INDUSTRIAL_MIXER.get();
    }
}

