/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck;

import com.mraof.minestuck.computer.editmode.DeployList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.MOD)
public class MinestuckConfig {
    static final ModConfigSpec commonSpec;
    public static final Common COMMON;
    static final ModConfigSpec clientSpec;
    public static final Client CLIENT;
    static final ModConfigSpec serverSpec;
    public static final Server SERVER;

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && server.isSameThread()) {
            DeployList.onConditionsUpdated(server);
        }
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(Common::new);
        COMMON = (Common)pair.getLeft();
        commonSpec = (ModConfigSpec)pair.getRight();
        pair = new ModConfigSpec.Builder().configure(Client::new);
        CLIENT = (Client)pair.getLeft();
        clientSpec = (ModConfigSpec)pair.getRight();
        pair = new ModConfigSpec.Builder().configure(Server::new);
        SERVER = (Server)pair.getLeft();
        serverSpec = (ModConfigSpec)pair.getRight();
    }

    public static class Common {
        public final ModConfigSpec.BooleanValue logIngredientItemsWithoutCosts;
        public final ModConfigSpec.BooleanValue logItemsWithRecipeAndCost;
        public final ModConfigSpec.IntValue entryDelay;

        private Common(ModConfigSpec.Builder builder) {
            builder.comment("If you're looking for a config option that isn't here, try looking in the world-specific config").push("logging");
            this.logIngredientItemsWithoutCosts = builder.comment("Makes the recipe-generated grist cost process log any items that are used as recipe ingredients, but is neither the output of a different recipe, or has a grist cost. Useful for finding items that probably need manual grist costs.").define("logIngredientItemsWithoutCosts", false);
            this.logItemsWithRecipeAndCost = builder.comment("Makes the recipe-generated grist cost process log any items that has a grist cost, but which could also be provided as a recipe generated cost. Useful for finding items that probably do not need manual grist costs.").define("logItemsWithRecipeAndCost", false);
            builder.pop();
            builder.push("performance");
            this.entryDelay = builder.comment("Time reserved for worldgen between generating the land and the actual entry. Measured in ticks. Try increasing this if entry halts the game too much.").defineInRange("entryDelay", 200, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static class Client {
        public final ModConfigSpec.EnumValue<AnimationSpeed> echeladderAnimation;
        public final ModConfigSpec.BooleanValue loginColorSelector;
        public final ModConfigSpec.BooleanValue alchemyIcons;
        public final ModConfigSpec.BooleanValue npcDialogueTextColors;

        private Client(ModConfigSpec.Builder builder) {
            builder.push("client");
            this.alchemyIcons = builder.comment("Set this to true to replace grist names in alchemiter/grist widget with the grist icon.").define("alchemyIcons", true);
            this.loginColorSelector = builder.comment("Determines if the color selector should be displayed when entering a save file for the first time.").define("loginColorSelector", true);
            this.echeladderAnimation = builder.comment("Allows control of standard speed for the echeladder rung \"animation\", or if it should have one in the first place.").defineEnum("echeladderAnimation", (Enum)AnimationSpeed.NORMAL);
            this.npcDialogueTextColors = builder.comment("Determines whether an NPC will use their custom formatted color value when talking in a dialogue screen.").define("npcDialogueTextColors", true);
            builder.pop();
        }
    }

    public static class Server {
        public final ModConfigSpec.BooleanValue cruxtruderIntake;
        public final ModConfigSpec.ConfigValue<List<String>> forbiddenWorldsTpz;
        public final ModConfigSpec.ConfigValue<List<String>> forbiddenDimensionTypesTpz;
        public final ModConfigSpec.BooleanValue disableGristWidget;
        public final ModConfigSpec.IntValue alchemiterMaxStacks;
        public final ModConfigSpec.IntValue puzzleBlockTickRate;
        public final ModConfigSpec.BooleanValue canBreakGates;
        public final ModConfigSpec.BooleanValue disableGiclops;
        public final ModConfigSpec.BooleanValue naturalImpSpawn;
        public final ModConfigSpec.BooleanValue naturalOgreSpawn;
        public final ModConfigSpec.BooleanValue naturalBasiliskSpawn;
        public final ModConfigSpec.BooleanValue naturalLichSpawn;
        public final ModConfigSpec.BooleanValue allowSecondaryConnections;
        public final ModConfigSpec.BooleanValue dropItemsInCards;
        public final ModConfigSpec.IntValue initialModusSize;
        public final ModConfigSpec.IntValue modusMaxSize;
        public final ModConfigSpec.EnumValue<DropMode> sylladexDropMode;
        public final ModConfigSpec.EnumValue<AvailableOptions> treeModusSetting;
        public final ModConfigSpec.EnumValue<AvailableOptions> hashmapChatModusSetting;
        public final ModConfigSpec.BooleanValue hardMode;
        public final ModConfigSpec.BooleanValue echeladderProgress;
        public final ModConfigSpec.BooleanValue playerSelectedTitle;
        public final ModConfigSpec.BooleanValue rungHealthOnRespawn;
        public final ModConfigSpec.IntValue dialogueRenewalSpeed;
        public final ModConfigSpec.IntValue lotusRestorationTime;
        public final ModConfigSpec.BooleanValue entryCrater;
        public final ModConfigSpec.BooleanValue adaptEntryBlockHeight;
        public final ModConfigSpec.BooleanValue stopSecondEntry;
        public final ModConfigSpec.BooleanValue needComputer;
        public final ModConfigSpec.IntValue artifactRange;
        public final ModConfigSpec.BooleanValue privateComputers;
        public final ModConfigSpec.BooleanValue globalSession;
        public final ModConfigSpec.EnumValue<PermissionType> dataCheckerPermission;
        public final ModConfigSpec.BooleanValue showGristChanges;
        public final ModConfigSpec.BooleanValue gristRefund;
        public final ModConfigSpec.BooleanValue deployCard;
        public final ModConfigSpec.BooleanValue portableMachines;
        public final ModConfigSpec.IntValue overworldEditRange;
        public final ModConfigSpec.IntValue landEditRange;
        public final ModConfigSpec.BooleanValue giveItems;

        private Server(ModConfigSpec.Builder builder) {
            builder.push("mechanics");
            this.echeladderProgress = builder.comment("If this is true, players will be able to see their progress towards the next rung. This is server side and will only be active in multiplayer if the server/Lan host has it activated.").define("echeladderProgress", true);
            this.rungHealthOnRespawn = builder.comment("If true, players will respawn with full health, rung bonuses included. If false, health will be left alone (typically meaning that you respawn with 10 hearts)").define("rungHealthOnRespawn", true);
            this.playerSelectedTitle = builder.comment("Enable this to let players select their own title. They will however not be able to select the Lord or Muse as class.").define("playerSelectedTitle", true);
            this.dialogueRenewalSpeed = builder.comment("Determines how quickly consort dialogue and store stocks are renewed.").defineInRange("dialogueRenewalSpeed", 2, 0, 1000);
            this.lotusRestorationTime = builder.comment("Determines how many seconds it takes for the lotus blossom to regrow after the opening process has started.").defineInRange("lotusRestorationTime", 300, 30, Integer.MAX_VALUE);
            this.hardMode = builder.define("hardMode", false);
            builder.pop();
            builder.push("sylladex");
            this.dropItemsInCards = builder.comment("When sylladices may drop items and cards at the same time, this option determines if items should be dropped inside of cards or items and cards as different stacks.").define("dropItemsInCards", true);
            this.initialModusSize = builder.comment("The initial amount of captchalogue cards in your sylladex.").defineInRange("initialModusSize", 5, 0, Integer.MAX_VALUE);
            this.modusMaxSize = builder.comment("The max size on a modus. Ignored if the value is 0.").defineInRange("modusMaxSize", 0, 0, Integer.MAX_VALUE);
            this.sylladexDropMode = builder.comment("Determines which items from the modus that are dropped on death. \"items\": Only the items are dropped. \"cards_and_items\": Both items and cards are dropped. (So that you have at most initial_modus_size amount of cards) \"all\": Everything is dropped, even the modus.").defineEnum("dropMode", (Enum)DropMode.CARDS_AND_ITEMS);
            this.treeModusSetting = builder.comment("This determines if auto-balance should be forced. 'both' if the player should choose, 'on' if forced at on, and 'off' if forced at off.").defineEnum("treeModusSetting", (Enum)AvailableOptions.BOTH);
            this.hashmapChatModusSetting = builder.comment("This determines if hashmap chat ejection should be forced. 'both' if the player should choose, 'on' if forced at on, and 'off' if forced at off.").defineEnum("hashmapModusSetting", (Enum)AvailableOptions.BOTH);
            builder.pop();
            builder.push("computer");
            this.privateComputers = builder.comment("True if computers should only be able to be used by the owner.").define("privateComputers", true);
            this.globalSession = builder.comment("Whenever all sburb connections should be put into a single session or not.").define("globalSession", false);
            this.dataCheckerPermission = builder.comment("Determines who's allowed to access the data checker. \"none\": No one is allowed. \"ops\": only those with a command permission of level 2 or more may access the data ckecker. (for single player, that would be if cheats are turned on) \"gamemode\": Only players with the creative or spectator gamemode may view the data checker. \"ops_or_gamemode\": Both ops and players in creative or spectator mode may view the data checker. \"anyone\": No access restrictions are used.").defineEnum("dataCheckerPermission", (Enum)PermissionType.OPS_OR_GAMEMODE);
            builder.pop();
            builder.push("editMode");
            this.showGristChanges = builder.comment("If this is true, grist change messages will appear.").define("showGristChanges", true);
            this.gristRefund = builder.comment("Enable this and players will get a (full) grist refund from breaking blocks in editmode.").define("gristRefund", false);
            this.deployCard = builder.comment("Determines if a card with a captcha card punched on it should be added to the deploy list.").define("deployCard", false);
            this.portableMachines = builder.comment("Determines if the small portable machines should be included in the deploy list.").define("portableMachines", false);
            this.giveItems = builder.comment("Setting this to true replaces editmode with the old Give Items button.").define("giveItems", false);
            this.overworldEditRange = builder.comment("A number that determines how far away from the computer an editmode player may be before entry.").defineInRange("overworldEditRange", 15, 1, Integer.MAX_VALUE);
            this.landEditRange = builder.comment("A number that determines how far away from the center of the brought land that an editmode player may be after entry.").defineInRange("landEditRange", 30, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.push("machines");
            this.disableGristWidget = builder.comment("Disable Grist Widget").define("disableGristWidget", false);
            this.alchemiterMaxStacks = builder.comment("The number of stacks that can be alchemized at the same time with the alchemiter.").defineInRange("alchemiterMaxStacks", 16, 0, 999);
            this.puzzleBlockTickRate = builder.comment("How often puzzle/redstone related blocks such as the remote observer tick.").defineInRange("puzzleBlockTickRate", 6, 2, 10);
            this.cruxtruderIntake = builder.comment("If enabled, the regular cruxtruder will require raw cruxite to function, which is inserted through the pipe.").define("cruxtruderIntake", true);
            this.forbiddenWorldsTpz = builder.comment("A list of worlds that you cannot travel to or from using transportalizers.").define("forbiddenWorldsTpz", new ArrayList());
            this.forbiddenDimensionTypesTpz = builder.comment("A list of dimension types that you cannot travel to or from using transportalizers.").define("forbiddenDimensionTypesTpz", new ArrayList());
            builder.pop();
            builder.push("entry");
            this.entryCrater = builder.comment("Disable this to prevent craters from people entering the medium.").define("entryCrater", true);
            this.adaptEntryBlockHeight = builder.comment("Adapt the transferred height to make the top non-air block to be placed at y:120. Makes entry take slightly longer.").define("adaptEntryBlockHeight", true);
            this.stopSecondEntry = builder.comment("If this is true, players may only use an artifact once, even if they end up in the overworld again.").define("stopSecondEntry", false);
            this.needComputer = builder.comment("If this is true, players need to have a computer nearby to Enter").define("needComputer", false);
            this.artifactRange = builder.comment("Radius of the land brought into the medium.").defineInRange("artifactRange", 30, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("medium");
            this.canBreakGates = builder.comment("Lets gates be destroyed by explosions. Turning this off will make gates use the same explosion resistance as bedrock.").define("canBreakGates", true);
            this.disableGiclops = builder.comment("Right now, the giclops pathfinding is currently causing huge amounts of lag due to their size. This option is a short-term solution that if true will disable giclops spawning and remove all existing giclopes.").define("disableGiclops", true);
            this.naturalImpSpawn = builder.comment("Determines if imps will spawn naturally. Note that this does not affect other spawning methods or any imps that has already spawned.").define("naturalImpSpawn", true);
            this.naturalOgreSpawn = builder.comment("Determines if ogres will spawn naturally. Note that this does not affect other spawning methods or any ogres that has already spawned.").define("naturalOgreSpawn", true);
            this.naturalBasiliskSpawn = builder.comment("Determines if basilisks will spawn naturally. Note that this does not affect other spawning methods or any basilisks that has already spawned.").define("naturalBasiliskSpawn", true);
            this.naturalLichSpawn = builder.comment("Determines if liches will spawn naturally. Note that this does not affect other spawning methods or any liches that has already spawned.").define("naturalLichSpawn", true);
            this.allowSecondaryConnections = builder.comment("Set this to true to allow so-called 'secondary connections' to be created.").define("secondaryConnections", true);
            builder.pop();
        }
    }

    public static enum AnimationSpeed {
        NOTHING(0),
        SLOW(1),
        NORMAL(2),
        FAST(4);

        private final int factor;

        private AnimationSpeed(int factor) {
            this.factor = factor;
        }

        public int getSpeed() {
            return this.factor;
        }
    }

    public static enum PermissionType {
        NONE,
        OPS,
        GAMEMODE,
        OPS_OR_GAMEMODE,
        ANYONE;

    }

    public static enum AvailableOptions {
        BOTH,
        ON,
        OFF;

    }

    public static enum DropMode {
        ITEMS,
        CARDS_AND_ITEMS,
        ALL;

    }
}

