/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import com.mraof.minestuck.inventory.captchalogue.ModusType;
import com.mraof.minestuck.inventory.captchalogue.ModusTypes;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CaptchalogueTrigger
extends SimpleCriterionTrigger<Instance> {
    public Codec<Instance> codec() {
        return Instance.CODEC;
    }

    public void trigger(ServerPlayer player, Modus modus, ItemStack item) {
        this.trigger(player, instance -> instance.test(modus.getType(), item, modus.getNonEmptyCards()));
    }

    public record Instance(Optional<ContextAwarePredicate> player, Optional<ModusType<?>> modus, Optional<ItemPredicate> item, MinMaxBounds.Ints count) implements SimpleCriterionTrigger.SimpleInstance
    {
        private static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)ModusTypes.REGISTRY.byNameCodec().optionalFieldOf("modus").forGetter(Instance::modus), (App)ItemPredicate.CODEC.optionalFieldOf("item").forGetter(Instance::item), (App)MinMaxBounds.Ints.CODEC.fieldOf("count").forGetter(Instance::count)).apply((Applicative)instance, Instance::new));

        public boolean test(ModusType<?> modus, ItemStack item, int count) {
            return !(!this.modus.isEmpty() && !this.modus.get().equals(modus) || !this.item.isEmpty() && !this.item.get().test(item) || !this.count.matches(count));
        }
    }
}

