/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.advancements.MSCriteriaTriggers;
import com.mraof.minestuck.entity.consort.ConsortEntity;
import com.mraof.minestuck.entity.consort.EnumConsort;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ConsortItemTrigger
extends SimpleCriterionTrigger<Instance> {
    public Codec<Instance> codec() {
        return Instance.CODEC;
    }

    public void trigger(ServerPlayer player, String table, ItemStack item, ConsortEntity consort) {
        this.trigger(player, instance -> instance.test(table, item, consort.merchantType));
    }

    public record Instance(Optional<ContextAwarePredicate> player, Optional<String> table, Optional<ItemPredicate> item, Optional<EnumConsort.MerchantType> type) implements SimpleCriterionTrigger.SimpleInstance
    {
        private static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)Codec.STRING.optionalFieldOf("table").forGetter(Instance::table), (App)ItemPredicate.CODEC.optionalFieldOf("item").forGetter(Instance::item), (App)EnumConsort.MerchantType.CODEC.optionalFieldOf("type").forGetter(Instance::type)).apply((Applicative)instance, Instance::new));

        public static Criterion<Instance> forType(EnumConsort.MerchantType type) {
            return MSCriteriaTriggers.CONSORT_ITEM.get().createCriterion((CriterionTriggerInstance)new Instance(Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(type)));
        }

        public boolean test(String table, ItemStack item, EnumConsort.MerchantType type) {
            return !(!this.table.isEmpty() && !this.table.get().equals(table) || !this.item.isEmpty() && !this.item.get().test(item) || !this.type.isEmpty() && this.type.get() != type);
        }
    }
}

