/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.advancements.MSCriteriaTriggers;
import com.mraof.minestuck.entity.consort.ConsortEntity;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ConsortTalkTrigger
extends SimpleCriterionTrigger<Instance> {
    public Codec<Instance> codec() {
        return Instance.CODEC;
    }

    public void trigger(ServerPlayer player, String message, ConsortEntity consort) {
        this.trigger(player, instance -> instance.test(message));
    }

    public record Instance(Optional<ContextAwarePredicate> player, Optional<String> message) implements SimpleCriterionTrigger.SimpleInstance
    {
        private static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)Codec.STRING.optionalFieldOf("message").forGetter(Instance::message)).apply((Applicative)instance, Instance::new));

        public static Criterion<Instance> any() {
            return MSCriteriaTriggers.CONSORT_TALK.get().createCriterion((CriterionTriggerInstance)new Instance(Optional.empty(), Optional.empty()));
        }

        public static Criterion<Instance> forMessage(String message) {
            return MSCriteriaTriggers.CONSORT_TALK.get().createCriterion((CriterionTriggerInstance)new Instance(Optional.empty(), Optional.of(message)));
        }

        public boolean test(String message) {
            return this.message.isEmpty() || this.message.get().equals(message);
        }
    }
}

