/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.alchemy;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mraof.minestuck.alchemy.PredeterminedCardCaptchas;
import com.mraof.minestuck.world.storage.MSExtraData;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CardCaptchas {
    public static final String AVAILABLE_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!?";
    public static final String EMPTY_CARD_CAPTCHA = "00000000";
    private final BiMap<Item, String> captchasMap = HashBiMap.create();
    private static final Logger LOGGER = LogManager.getLogger();

    @Nonnull
    public static String getCaptcha(Item item, MinecraftServer server) {
        MSExtraData data = MSExtraData.get(server);
        CardCaptchas captchas = data.getCardCaptchas();
        if (PredeterminedCardCaptchas.getData().containsKey((Object)item)) {
            if (captchas.captchasMap.containsKey((Object)item)) {
                LOGGER.warn("Conflict: Item {} already has Code '{}', removing generated Code '{}' from data.", (Object)item, PredeterminedCardCaptchas.getData().get((Object)item), captchas.captchasMap.get((Object)item));
                captchas.captchasMap.remove((Object)item);
                data.setDirty();
            }
            return (String)PredeterminedCardCaptchas.getData().get((Object)item);
        }
        if (captchas.captchasMap.containsKey((Object)item)) {
            return (String)captchas.captchasMap.get((Object)item);
        }
        String captcha = captchas.createCaptchaForItem(item, server.overworld().getSeed());
        captchas.captchasMap.put((Object)item, (Object)captcha);
        data.setDirty();
        return captcha;
    }

    @Nullable
    public static Item getItemFromCaptcha(String captcha, MinecraftServer server) {
        MSExtraData data = MSExtraData.get(server);
        CardCaptchas captchas = data.getCardCaptchas();
        if (PredeterminedCardCaptchas.getData().inverse().containsKey((Object)captcha)) {
            if (captchas.captchasMap.inverse().containsKey((Object)captcha)) {
                LOGGER.warn("Conflict: Code '{}' already has assigned to Item {}, removing code '{}' reference to Item {}.", (Object)captcha, PredeterminedCardCaptchas.getData().inverse().get((Object)captcha), (Object)captcha, captchas.captchasMap.inverse().get((Object)captcha));
                captchas.captchasMap.inverse().remove((Object)captcha);
                data.setDirty();
            }
            return (Item)PredeterminedCardCaptchas.getData().inverse().get((Object)captcha);
        }
        return (Item)captchas.captchasMap.inverse().get((Object)captcha);
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry entry : this.captchasMap.entrySet()) {
            String itemName = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)((Item)entry.getKey()))).toString();
            tag.putString(itemName, (String)entry.getValue());
        }
        return tag;
    }

    public void deserialize(CompoundTag tag) {
        this.captchasMap.clear();
        for (String itemName : tag.getAllKeys()) {
            Item item;
            ResourceLocation itemId = ResourceLocation.tryParse((String)itemName);
            if (itemId == null || (item = (Item)BuiltInRegistries.ITEM.get(itemId)) == null) continue;
            this.captchasMap.put((Object)item, (Object)tag.getString(itemName));
        }
    }

    private String createCaptchaForItem(Item item, long seed) {
        ResourceLocation itemId = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item));
        RandomSource itemRandom = RandomSource.create((long)seed).forkPositional().fromHashOf("minestuck:item_captchas").forkPositional().fromHashOf(itemId);
        String fullHash = CardCaptchas.createHash(itemId.toString());
        String shuffledHash = CardCaptchas.shuffleHash(fullHash, itemRandom);
        String cutHash = shuffledHash.substring(shuffledHash.length() - 16);
        String captcha = CardCaptchas.captchaFromHash(cutHash);
        if (this.captchasMap.containsValue((Object)captcha) || PredeterminedCardCaptchas.getData().containsValue((Object)captcha)) {
            return this.generateBackupCaptcha(itemRandom);
        }
        return captcha;
    }

    private static String createHash(String registryName) {
        StringBuilder hexString = new StringBuilder();
        try {
            byte[] hashBytes;
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] inputBytes = registryName.getBytes();
            for (byte bytes : hashBytes = digest.digest(inputBytes)) {
                String hex = String.format("%02x", bytes);
                hexString.append(hex);
            }
        }
        catch (NoSuchAlgorithmException exception) {
            exception.printStackTrace();
        }
        return hexString.toString();
    }

    private static String captchaFromHash(String cutHash) {
        StringBuilder captchaBuilder = new StringBuilder();
        for (int captchaElement = 0; captchaElement < 8; ++captchaElement) {
            String hashSegment = cutHash.substring(captchaElement * 2, captchaElement * 2 + 2);
            int decimalValue = Integer.parseInt(hashSegment, 16);
            int charValue = decimalValue % 64;
            captchaBuilder.append(AVAILABLE_CHARACTERS.charAt(charValue));
        }
        return captchaBuilder.toString();
    }

    private static String shuffleHash(String fullHash, RandomSource itemRandom) {
        char[] characters = fullHash.toCharArray();
        for (int currentIndex = 0; currentIndex < characters.length; ++currentIndex) {
            int randIndex = itemRandom.nextInt(currentIndex + 1);
            char temp = characters[currentIndex];
            characters[currentIndex] = characters[randIndex];
            characters[randIndex] = temp;
        }
        return new String(characters);
    }

    private String generateBackupCaptcha(RandomSource random) {
        StringBuilder captcha;
        String captchaString;
        do {
            captcha = new StringBuilder(8);
            for (int i = 0; i < 7; ++i) {
                int index = random.nextInt(AVAILABLE_CHARACTERS.length());
                char randomChar = AVAILABLE_CHARACTERS.charAt(index);
                captcha.append(randomChar);
            }
            captcha.append("#");
        } while (this.captchasMap.containsValue((Object)(captchaString = captcha.toString())) || PredeterminedCardCaptchas.getData().containsValue((Object)captchaString));
        return captchaString;
    }
}

