/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.alchemy;

import com.mojang.serialization.DynamicOps;
import com.mraof.minestuck.api.alchemy.GristAmount;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.NonNegativeGristSet;
import com.mraof.minestuck.player.Echeladder;
import com.mraof.minestuck.player.GristCache;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerData;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.player.PlayerSavedData;
import com.mraof.minestuck.skaianet.SburbPlayerData;
import com.mraof.minestuck.skaianet.Session;
import com.mraof.minestuck.skaianet.SessionHandler;
import com.mraof.minestuck.util.MSAttachments;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public class GristGutter {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int GUTTER_CAPACITY = 10000;
    private final MinecraftServer mcServer;
    private final Session session;
    private final NonNegativeGristSet gristSet;
    private long gristTotal;

    public GristGutter(MinecraftServer mcServer, Session session) {
        this.mcServer = mcServer;
        this.session = session;
        this.gristSet = new NonNegativeGristSet();
        this.gristTotal = 0L;
    }

    public GristGutter(MinecraftServer mcServer, Session session, Tag tag) {
        this.mcServer = mcServer;
        this.session = session;
        this.gristSet = NonNegativeGristSet.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(new NonNegativeGristSet());
        this.gristTotal = 0L;
        for (GristAmount amount : this.gristSet.asAmounts()) {
            this.gristTotal += amount.amount();
        }
    }

    public Tag write() {
        return (Tag)NonNegativeGristSet.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.gristSet).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(EndTag.INSTANCE);
    }

    public static Optional<GristGutter> get(ServerPlayer player) {
        PlayerIdentifier playerIdentifier = IdentifierHandler.encode((Player)player);
        if (playerIdentifier == null) {
            return Optional.empty();
        }
        return Optional.of(GristGutter.get(playerIdentifier, player.server));
    }

    public static GristGutter get(PlayerIdentifier player, MinecraftServer mcServer) {
        return SessionHandler.get(mcServer).getOrCreateSession(player).getGristGutter();
    }

    public GristSet getCache() {
        return this.gristSet.asImmutable();
    }

    private Stream<PlayerIdentifier> gutterPlayers() {
        return this.session.getPlayers().stream().filter(player -> SburbPlayerData.get(player, this.mcServer).hasEntered());
    }

    public long getRemainingCapacity() {
        return Math.max(0L, (long)(10000.0 * this.gutterMultiplierForSession()) - this.gristTotal);
    }

    public double gutterMultiplierForSession() {
        PlayerSavedData playerSavedData = PlayerSavedData.get(this.mcServer);
        return this.gutterPlayers().map(player -> (Double)playerSavedData.getOrCreateData((PlayerIdentifier)player).getData(MSAttachments.GUTTER_MULTIPLIER)).reduce(0.0, Double::sum);
    }

    public void addGristFrom(MutableGristSet set) {
        for (GristAmount amount : set.asAmounts()) {
            GristType type = amount.type();
            long maximumAllowed = this.getRemainingCapacity();
            if (maximumAllowed <= 0L) {
                return;
            }
            long amountToAdd = Math.min(maximumAllowed, amount.amount());
            set.add(type, -amountToAdd);
            this.addGristInternal(type, amountToAdd);
        }
    }

    public void addGristUnchecked(GristSet set) {
        for (GristAmount amount : set.asAmounts()) {
            this.addGristInternal(amount.type(), amount.amount());
        }
    }

    private void addGristInternal(GristType type, long amount) {
        this.gristSet.add(type, amount);
        this.gristTotal += amount;
    }

    public MutableGristSet takeFraction(double fraction) {
        MutableGristSet takenGrist = MutableGristSet.newDefault();
        double extraGrist = 0.0;
        for (GristAmount gristAmount : this.gristSet.asAmounts()) {
            double takenAmount = extraGrist + fraction * (double)gristAmount.amount();
            long actualAmount = Math.round(takenAmount);
            extraGrist = takenAmount - (double)actualAmount;
            takenGrist.add(gristAmount.type(), actualAmount);
            this.addGristInternal(gristAmount.type(), -actualAmount);
        }
        return takenGrist;
    }

    @SubscribeEvent
    public static void onServerTickEvent(ServerTickEvent.Pre event) {
        if (event.getServer().overworld().getGameTime() % 200L == 0L) {
            for (Session session : SessionHandler.get(event.getServer()).getSessions()) {
                session.getGristGutter().distributeToPlayers();
            }
        }
    }

    private void distributeToPlayers() {
        RandomSource rand = this.mcServer.overworld().random;
        List playerList = this.gutterPlayers().collect(Collectors.toCollection(ArrayList::new));
        Collections.shuffle(playerList, new Random(rand.nextLong()));
        for (PlayerIdentifier player : playerList) {
            this.tickDistributionToPlayer(player, rand);
        }
    }

    private void tickDistributionToPlayer(PlayerIdentifier player, RandomSource rand) {
        NonNegativeGristSet capacity;
        MutableGristSet gristToTransfer;
        PlayerData data = PlayerData.get(player, this.mcServer);
        long spliceAmount = (long)((double)Echeladder.get(data).getGristCapacity() * this.getDistributionRateModifier());
        GristCache gristCache = GristCache.get(data);
        MutableGristSet remainder = gristCache.addWithinCapacity(gristToTransfer = this.takeWithinCapacity(spliceAmount, capacity = gristCache.getCapacitySet(), rand), null);
        if (!remainder.isEmpty()) {
            throw new IllegalStateException("Took more grist than could be given to the player. Got back grist: " + String.valueOf(remainder));
        }
    }

    private double getDistributionRateModifier() {
        return 0.05;
    }

    private MutableGristSet takeWithinCapacity(long amount, NonNegativeGristSet capacity, RandomSource rand) {
        long remaining = amount;
        MutableGristSet takenGrist = MutableGristSet.newDefault();
        ArrayList<GristAmount> amounts = new ArrayList<GristAmount>(capacity.asAmounts());
        Collections.shuffle(amounts, new Random(rand.nextLong()));
        for (GristAmount capacityAmount : amounts) {
            GristType type = capacityAmount.type();
            long amountInGutter = this.gristSet.getGrist(type);
            if (amountInGutter <= 0L) continue;
            long takenAmount = Math.min(remaining, Math.min(capacityAmount.amount(), amountInGutter));
            this.addGristInternal(type, -takenAmount);
            takenGrist.add(type, takenAmount);
            if ((remaining -= takenAmount) > 0L) continue;
            break;
        }
        return takenGrist;
    }
}

