/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.alchemy;

import com.mojang.serialization.DynamicOps;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.GristTypeSpawnCategory;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.entity.underling.UnderlingEntity;
import com.mraof.minestuck.event.GristDropsEvent;
import com.mraof.minestuck.player.PlayerIdentifier;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class GristHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Tag encodeGristType(GristType gristType) {
        return (Tag)GristTypes.REGISTRY.byNameCodec().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)gristType).getOrThrow();
    }

    public static Optional<GristType> parseGristType(Tag tag) {
        return GristTypes.REGISTRY.byNameCodec().parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0));
    }

    public static GristType getPrimaryGrist(RandomSource random) {
        List<WeightedEntry.Wrapper> typeList = GristTypeSpawnCategory.ANY.gristTypes().map(type -> WeightedEntry.wrap((Object)type, (int)Math.round(type.getRarity() * 100.0f))).toList();
        return (GristType)((WeightedEntry.Wrapper)WeightedRandom.getRandomItem((RandomSource)random, typeList).orElseThrow()).data();
    }

    public static GristType getSecondaryGrist(RandomSource random, GristType primary) {
        return primary.getSecondaryTypes().flatMap(set -> set.getRandomElement(random).map(Holder::value)).orElse(primary);
    }

    public static MutableGristSet generateUnderlingGristDrops(UnderlingEntity entity, Map<PlayerIdentifier, Double> damageMap, double multiplier) {
        RandomSource random = entity.getRandom();
        GristType primary = entity.getGristType();
        GristType secondary = GristHelper.getSecondaryGrist(random, primary);
        MutableGristSet set = MutableGristSet.newDefault();
        set.add(GristTypes.BUILD, (long)((int)(2.0 * multiplier + random.nextDouble() * 18.0 * multiplier)));
        set.add(primary, (long)((int)(1.0 * multiplier + random.nextDouble() * 9.0 * multiplier)));
        set.add(secondary, (long)((int)(0.5 * multiplier + random.nextDouble() * 4.0 * multiplier)));
        GristDropsEvent event = (GristDropsEvent)NeoForge.EVENT_BUS.post((Event)new GristDropsEvent(entity, damageMap, set, primary, secondary, multiplier));
        if (event.isCanceled()) {
            return null;
        }
        return event.getNewDrops();
    }

    public static enum EnumSource {
        CLIENT,
        SERVER,
        SENDGRIST,
        GUTTER,
        CONSOLE;

    }
}

