/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.alchemy;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public class PredeterminedCardCaptchas {
    @Nullable
    private static BiMap<Item, String> predefinedCardMap;

    private static void setData(BiMap<Item, String> predefinedCards) {
        predefinedCardMap = predefinedCards;
    }

    public static BiMap<Item, String> getData() {
        return Objects.requireNonNull(predefinedCardMap, "Tried to get an instance of Predetermined Captchas too early.");
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        predefinedCardMap = null;
    }

    @SubscribeEvent
    public static void onResourceReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new Loader());
    }

    private static final class Loader
    extends SimplePreparableReloadListener<Map<String, Item>> {
        private static final Logger LOGGER = LogManager.getLogger();
        public static final String PATH = "minestuck/captcha_codes.json";
        private static final Codec<Map<String, Item>> PREDEFINED_CAPTCHAS_CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)BuiltInRegistries.ITEM.byNameCodec());

        private Loader() {
        }

        protected Map<String, Item> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
            HashBiMap captchaData = HashBiMap.create();
            for (String namespace : resourceManager.getNamespaces()) {
                Loader.parseCaptchaCodesFromNamespace(resourceManager, namespace).ifPresent(arg_0 -> Loader.lambda$prepare$0((BiMap)captchaData, arg_0));
            }
            return captchaData;
        }

        protected void apply(Map<String, Item> data, ResourceManager resourceManager, ProfilerFiller profiler) {
            ImmutableBiMap.Builder predefinedCards = ImmutableBiMap.builder();
            for (Map.Entry<String, Item> entrySet : data.entrySet()) {
                predefinedCards.put((Object)entrySet.getValue(), (Object)entrySet.getKey());
            }
            PredeterminedCardCaptchas.setData((BiMap<Item, String>)predefinedCards.build());
        }

        private static Optional<Map<String, Item>> parseCaptchaCodesFromNamespace(ResourceManager resourceManager, String namespace) {
            ResourceLocation rs = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)PATH);
            return resourceManager.getResource(rs).flatMap(resource -> {
                Optional optional;
                block8: {
                    BufferedReader reader = resource.openAsReader();
                    try {
                        JsonElement json = JsonParser.parseReader((Reader)reader);
                        optional = PREDEFINED_CAPTCHAS_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(message -> LOGGER.error("Problem parsing json: {}, reason: {}", (Object)rs, message));
                        if (reader == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException ignored) {
                            return Optional.empty();
                        }
                    }
                    ((Reader)reader).close();
                }
                return optional;
            });
        }

        private static void processCaptchaData(BiMap<String, Item> incompleteMap, Map<String, Item> parsedMap) {
            for (Map.Entry<String, Item> entry : parsedMap.entrySet()) {
                String captcha = entry.getKey();
                Item item = entry.getValue();
                if (incompleteMap.containsValue((Object)item)) {
                    LOGGER.error("Item {} already has an existing Code of '{}'!", (Object)item, incompleteMap.inverse().get((Object)item));
                    continue;
                }
                if (incompleteMap.containsKey((Object)captcha)) {
                    LOGGER.error("Code '{}' is already assigned to Item: {}!", (Object)captcha, incompleteMap.get((Object)captcha));
                    continue;
                }
                incompleteMap.put((Object)entry.getKey(), (Object)entry.getValue());
            }
        }

        private static /* synthetic */ void lambda$prepare$0(BiMap captchaData, Map parsedData) {
            Loader.processCaptchaData((BiMap<String, Item>)captchaData, parsedData);
        }
    }
}

