/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.alchemy.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.recipe.GristCostRecipe;
import com.mraof.minestuck.api.alchemy.recipe.JeiGristCost;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratedCostProvider;
import com.mraof.minestuck.item.crafting.MSRecipeTypes;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class GristCost
implements GristCostRecipe {
    private final Ingredient ingredient;
    @Nullable
    private final Integer priority;
    private final GristSet.Immutable cost;

    public GristCost(Ingredient ingredient, GristSet.Immutable cost, Optional<Integer> priority) {
        this.ingredient = ingredient;
        this.priority = priority.orElse(null);
        this.cost = cost;
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        return this.ingredient.test(input.item());
    }

    @Override
    public int getPriority() {
        return Objects.requireNonNullElseGet(this.priority, () -> GristCostRecipe.defaultPriority(this.ingredient));
    }

    @Override
    public GristSet getGristCost(ItemStack input, @Nullable GristType wildcardType, boolean shouldRoundDown) {
        return GristCostRecipe.scaleToCountAndDurability(this.cost, input, shouldRoundDown);
    }

    @Override
    public void addCostProvider(BiConsumer<Item, GeneratedCostProvider> consumer, ResourceLocation recipeId) {
        GristCostRecipe.addSimpleCostProvider(consumer, this, this.ingredient);
    }

    @Override
    public List<JeiGristCost> getJeiCosts(Level level) {
        return Collections.singletonList(new JeiGristCost.Set(this.ingredient, this.cost));
    }

    public RecipeSerializer<?> getSerializer() {
        return MSRecipeTypes.GRIST_COST.get();
    }

    public static class Serializer
    implements RecipeSerializer<GristCost> {
        private static final MapCodec<GristCost> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)GristSet.Codecs.MAP_CODEC.fieldOf("grist_cost").forGetter(recipe -> recipe.cost), (App)Codec.INT.optionalFieldOf("priority").forGetter(recipe -> Optional.ofNullable(recipe.priority))).apply((Applicative)instance, GristCost::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, GristCost> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<GristCost> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, GristCost> streamCodec() {
            return STREAM_CODEC;
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, GristCost recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
            buffer.writeInt(recipe.getPriority());
            GristSet.Codecs.STREAM_CODEC.encode((Object)buffer, (Object)recipe.cost);
        }

        private static GristCost fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int priority = buffer.readInt();
            GristSet.Immutable cost = (GristSet.Immutable)GristSet.Codecs.STREAM_CODEC.decode((Object)buffer);
            return new GristCost(ingredient, cost, Optional.of(priority));
        }
    }
}

