/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.alchemy.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.api.alchemy.recipe.combination.CombinationInput;
import com.mraof.minestuck.api.alchemy.recipe.combination.CombinationMode;
import com.mraof.minestuck.api.alchemy.recipe.combination.CombinationRecipe;
import com.mraof.minestuck.api.alchemy.recipe.combination.JeiCombination;
import com.mraof.minestuck.item.crafting.MSRecipeTypes;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public record RegularCombinationRecipe(Ingredient input1, Ingredient input2, CombinationMode mode, ItemStack output) implements CombinationRecipe
{
    public boolean matches(CombinationInput input, Level level) {
        return input.mode() == this.mode && (this.input1.test(input.input1()) && this.input2.test(input.input2()) || this.input2.test(input.input1()) && this.input1.test(input.input2()));
    }

    public ItemStack assemble(CombinationInput pInput, HolderLookup.Provider pRegistries) {
        return this.output;
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    @Override
    public List<JeiCombination> getJeiCombinations() {
        return Collections.singletonList(new JeiCombination(this.input1, this.input2, this.output, this.mode));
    }

    public RecipeSerializer<?> getSerializer() {
        return MSRecipeTypes.COMBINATION.get();
    }

    public static class Serializer
    implements RecipeSerializer<RegularCombinationRecipe> {
        private static final MapCodec<RegularCombinationRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input1").forGetter(recipe -> recipe.input1), (App)Ingredient.CODEC_NONEMPTY.fieldOf("input2").forGetter(recipe -> recipe.input2), (App)CombinationMode.CODEC.fieldOf("mode").forGetter(recipe -> recipe.mode), (App)ItemStack.SIMPLE_ITEM_CODEC.fieldOf("output").forGetter(recipe -> recipe.output)).apply((Applicative)instance, RegularCombinationRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, RegularCombinationRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, RegularCombinationRecipe::input1, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, RegularCombinationRecipe::input2, (StreamCodec)NeoForgeStreamCodecs.enumCodec(CombinationMode.class), RegularCombinationRecipe::mode, (StreamCodec)ItemStack.STREAM_CODEC, RegularCombinationRecipe::output, RegularCombinationRecipe::new);

        public MapCodec<RegularCombinationRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RegularCombinationRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

