/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.alchemy.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.recipe.GristCostRecipe;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratedCostProvider;
import com.mraof.minestuck.item.crafting.MSRecipeTypes;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class UnavailableGristCost
implements GristCostRecipe {
    private final Ingredient ingredient;
    @Nullable
    private final Integer priority;

    public UnavailableGristCost(Ingredient ingredient, Optional<Integer> priority) {
        this.ingredient = ingredient;
        this.priority = priority.orElse(null);
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        return this.ingredient.test(input.item());
    }

    @Override
    public int getPriority() {
        return Objects.requireNonNullElseGet(this.priority, () -> GristCostRecipe.defaultPriority(this.ingredient));
    }

    @Override
    @Nullable
    public GristSet getGristCost(ItemStack input, @Nullable GristType wildcardType, boolean shouldRoundDown) {
        return null;
    }

    @Override
    public void addCostProvider(BiConsumer<Item, GeneratedCostProvider> consumer, ResourceLocation recipeId) {
        GristCostRecipe.addSimpleCostProvider(consumer, this, this.ingredient);
    }

    public RecipeSerializer<?> getSerializer() {
        return MSRecipeTypes.UNAVAILABLE_GRIST_COST.get();
    }

    public static class Serializer
    implements RecipeSerializer<UnavailableGristCost> {
        private static final MapCodec<UnavailableGristCost> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)Codec.INT.optionalFieldOf("priority").forGetter(recipe -> Optional.ofNullable(recipe.priority))).apply((Applicative)instance, UnavailableGristCost::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, UnavailableGristCost> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<UnavailableGristCost> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, UnavailableGristCost> streamCodec() {
            return STREAM_CODEC;
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, UnavailableGristCost recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
            buffer.writeInt(recipe.getPriority());
        }

        private static UnavailableGristCost fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int priority = buffer.readInt();
            return new UnavailableGristCost(ingredient, Optional.of(priority));
        }
    }
}

